/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.text.Spannable;
import com.yy.mobile.richtext.AirTicketFilter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YGroupTicketFilter
extends AirTicketFilter {
    private static final String PREFIX = "Y\u7fa4";
    private static final String GROUP_TICKET_REG = "(((?i)yy)://qun-\\[gaid=([0-9]+)&action=add])";
    private static final Pattern GROUP_TICKET_PATTERN = Pattern.compile("(((?i)yy)://qun-\\[gaid=([0-9]+)&action=add])");
    private static final String NUMBER_REG = "[0-9]+";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");

    public YGroupTicketFilter(int id2) {
        super(id2);
    }

    public static List<GroupTicketInfo> parseGroupTicket(String msg) {
        ArrayList<GroupTicketInfo> infoList = new ArrayList<GroupTicketInfo>();
        Matcher matcher = GROUP_TICKET_PATTERN.matcher(msg);
        while (matcher.find()) {
            String groupMsg = msg.substring(matcher.start(), matcher.end());
            Matcher m = NUMBER_PATTERN.matcher(groupMsg);
            try {
                if (!m.find()) continue;
                infoList.add(new GroupTicketInfo(matcher.start(), matcher.end(), Long.parseLong(groupMsg.substring(m.start(), m.end()))));
            }
            catch (NumberFormatException e) {
                MLog.error((Object)"hjinw", "parse Channel sid or subSid error :%s", e, new Object[0]);
            }
        }
        return infoList;
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        if (!YGroupTicketFilter.isYGroupTicketMessage((CharSequence)spannable)) {
            return;
        }
        if (this.ticketDrawable == null) {
            this.ticketDrawable = this.getTicketDrawable(context);
        }
        this.setSpannable(spannable, maxWidth);
    }

    private void setSpannable(Spannable spannable) {
        this.setSpannable(spannable, Integer.MAX_VALUE);
    }

    private void setSpannable(Spannable spannable, int maxWidth) {
        List<GroupTicketInfo> infos = YGroupTicketFilter.parseGroupTicket(spannable.toString());
        for (GroupTicketInfo info : infos) {
            AirTicketFilter.AirTicketSpan groupTicketSpan = new AirTicketFilter.AirTicketSpan(this.ticketDrawable, PREFIX + String.valueOf(info.groupAliasId), maxWidth);
            GroupTicketClickSpan clickSpan = new GroupTicketClickSpan(info.groupAliasId);
            this.setSpannable(FP.toList(new Object[]{groupTicketSpan, clickSpan}), spannable, info.start, info.end, 33);
        }
    }

    public static boolean isYGroupTicketMessage(CharSequence msg) {
        return GROUP_TICKET_PATTERN.matcher(msg).find();
    }

    public static String replaceGroupTicketWithGivenStr(String message, String givenStr) {
        Matcher m = GROUP_TICKET_PATTERN.matcher(message);
        return m.replaceAll(givenStr).trim();
    }

    public static class GroupTicketInfo {
        public int start;
        public int end;
        public long groupAliasId;

        public GroupTicketInfo(int start, int end, long aliasId) {
            this.start = start;
            this.end = end;
            this.groupAliasId = aliasId;
        }

        public String toString() {
            return "[start = " + this.start + "; end = " + this.end + "; groupId = " + this.groupAliasId + "]";
        }
    }

    public class GroupTicketClickSpan
    extends AirTicketFilter.TicketClickSpan {
        public final long groupAliasId;

        public GroupTicketClickSpan(long gAliasId) {
            this.groupAliasId = gAliasId;
        }
    }
}

