/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.taskexecutor;

import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.taskexecutor.FifoPriorityThreadPoolExecutor;
import com.yy.mobile.util.taskexecutor.RuntimeCompat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/yy/mobile/util/taskexecutor/YYTaskExecutorHelper;", "", "()V", "CORE_SIZE", "", "giftSingleThreadPool", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "sComputeThreadPool", "Lcom/yy/mobile/util/taskexecutor/FifoPriorityThreadPoolExecutor;", "sIOThreadPool", "sThreadPool", "singleThreadPool", "getComputePool", "Ljava/util/concurrent/ThreadPoolExecutor;", "getGiftSinglePool", "getIOThreadPool", "getNormalPool", "getSinglePool", "framework_release"})
public final class YYTaskExecutorHelper {
    private static final int CORE_SIZE;
    private static final FifoPriorityThreadPoolExecutor sIOThreadPool;
    private static FifoPriorityThreadPoolExecutor sThreadPool;
    private static FifoPriorityThreadPoolExecutor sComputeThreadPool;
    private static ScheduledExecutorService singleThreadPool;
    private static ScheduledExecutorService giftSingleThreadPool;
    public static final YYTaskExecutorHelper INSTANCE;

    @NotNull
    public final ThreadPoolExecutor getIOThreadPool() {
        return sIOThreadPool;
    }

    @NotNull
    public final ThreadPoolExecutor getComputePool() {
        return sComputeThreadPool;
    }

    @NotNull
    public final ThreadPoolExecutor getNormalPool() {
        return sThreadPool;
    }

    @NotNull
    public final ScheduledExecutorService getSinglePool() {
        ScheduledExecutorService scheduledExecutorService = singleThreadPool;
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"singleThreadPool");
        return scheduledExecutorService;
    }

    @NotNull
    public final ScheduledExecutorService getGiftSinglePool() {
        ScheduledExecutorService scheduledExecutorService = giftSingleThreadPool;
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"giftSingleThreadPool");
        return scheduledExecutorService;
    }

    private YYTaskExecutorHelper() {
    }

    static {
        YYTaskExecutorHelper yYTaskExecutorHelper;
        INSTANCE = yYTaskExecutorHelper = new YYTaskExecutorHelper();
        CORE_SIZE = RuntimeCompat.calculateBestThreadCount();
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        sIOThreadPool = new FifoPriorityThreadPoolExecutor(CORE_SIZE, basicConfig.isDebuggable() ? FifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.THROW : FifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.LOG, "YYTask-io-");
        int n = CORE_SIZE / 2;
        BasicConfig basicConfig2 = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig2, (String)"BasicConfig.getInstance()");
        sThreadPool = new FifoPriorityThreadPoolExecutor(n, basicConfig2.isDebuggable() ? FifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.THROW : FifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.LOG, "YYTask-normal-");
        int n2 = CORE_SIZE / 2;
        BasicConfig basicConfig3 = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig3, (String)"BasicConfig.getInstance()");
        sComputeThreadPool = new FifoPriorityThreadPoolExecutor(n2, basicConfig3.isDebuggable() ? FifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.THROW : FifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.LOG, "YYTask-compute-");
        singleThreadPool = Executors.newSingleThreadScheduledExecutor(new FifoPriorityThreadPoolExecutor.DefaultThreadFactory("YYTask-single-"));
        giftSingleThreadPool = Executors.newSingleThreadScheduledExecutor(new FifoPriorityThreadPoolExecutor.DefaultThreadFactory("YYTask-gift-single-"));
    }
}

