/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.taskexecutor;

import android.os.Process;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.Prioritized;
import com.yy.mobile.util.taskexecutor.ThreadPoolMonitor;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FifoPriorityThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    static final int THREAD_PRIORITY_LOW = 14;
    static final int THREAD_PRIORITY_BACKGROUND = 10;
    static final int THREAD_WORK_PRIORITY = 5;
    static final int THREAD_PRIORITY_NORMAL = 5;
    static final int THREAD_PRIORITY_HIGH = 0;
    private static final String TAG = "YYThreadPoolExecutor";
    private final AtomicInteger ordering = new AtomicInteger();
    private final UncaughtThrowableStrategy uncaughtThrowableStrategy;
    private ThreadPoolMonitor threadPoolMonitor = null;

    public FifoPriorityThreadPoolExecutor(int poolSize, String mThreadPrefix) {
        this(poolSize, UncaughtThrowableStrategy.LOG, mThreadPrefix);
    }

    public FifoPriorityThreadPoolExecutor(int poolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy, String mThreadPrefix) {
        this(poolSize, (ThreadFactory)new DefaultThreadFactory(mThreadPrefix), uncaughtThrowableStrategy);
    }

    @Deprecated
    public FifoPriorityThreadPoolExecutor(int poolSize, int maxPoolSize, UncaughtThrowableStrategy uncaughtThrowableStrategy, String mThreadPrefix) {
        this(poolSize, (ThreadFactory)new DefaultThreadFactory(mThreadPrefix), uncaughtThrowableStrategy);
    }

    @Deprecated
    public FifoPriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAlive, TimeUnit timeUnit, ThreadFactory threadFactory, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        this(corePoolSize, threadFactory, uncaughtThrowableStrategy);
    }

    public FifoPriorityThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        super(corePoolSize, threadFactory);
        this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
        this.threadPoolMonitor = threadFactory instanceof DefaultThreadFactory ? new ThreadPoolMonitor(((DefaultThreadFactory)threadFactory).mThreadPrefix, this) : new ThreadPoolMonitor("unkown", this);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new LoadTask<T>(runnable, value, this.ordering.getAndIncrement());
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (this.threadPoolMonitor != null) {
            this.threadPoolMonitor.beforeExecute(r);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.threadPoolMonitor != null) {
            this.threadPoolMonitor.shutdownNow();
        }
        return super.shutdownNow();
    }

    @Override
    public void shutdown() {
        if (this.threadPoolMonitor != null) {
            this.threadPoolMonitor.shutdown();
        }
        super.shutdown();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Future future;
        super.afterExecute(r, t);
        if (this.threadPoolMonitor != null && r != null) {
            this.threadPoolMonitor.afterExecute(r);
        }
        if (t == null && r instanceof Future && (future = (Future)((Object)r)).isDone() && !future.isCancelled()) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
            catch (ExecutionException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
        }
    }

    static class LoadTask<T>
    extends FutureTask<T>
    implements Prioritized,
    Comparable<Prioritized> {
        private final int priority;
        private final int order;

        public LoadTask(Runnable runnable, T result, int order) {
            super(runnable, result);
            this.priority = runnable instanceof Prioritized ? ((Prioritized)((Object)runnable)).getPriority() : 10;
            this.order = order;
        }

        public boolean equals(Object o) {
            if (o instanceof LoadTask) {
                LoadTask other = (LoadTask)o;
                return this.order == other.order && this.priority == other.priority;
            }
            return false;
        }

        public int hashCode() {
            int result = this.priority;
            result = 31 * result + this.order;
            return result;
        }

        @Override
        public int compareTo(Prioritized loadTask) {
            int result = loadTask.getPriority() - this.priority;
            if (result == 0 && loadTask instanceof LoadTask) {
                result = this.order - ((LoadTask)loadTask).order;
            }
            return result;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }

    public static class DefaultThreadFactory
    implements ThreadFactory {
        private String mThreadPrefix;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public DefaultThreadFactory(String mThreadPrefix) {
            this.mThreadPrefix = mThreadPrefix;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable, this.mThreadPrefix + this.threadNumber.getAndIncrement()){

                @Override
                public void run() {
                    Process.setThreadPriority((int)10);
                    super.run();
                }
            };
            if (result.isDaemon()) {
                result.setDaemon(false);
            }
            return result;
        }
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable t) {
                MLog.error((Object)FifoPriorityThreadPoolExecutor.TAG, "Request threw uncaught throwable", t, new Object[0]);
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable t) {
                super.handle(t);
                throw new RuntimeException(t);
            }
        };


        protected void handle(Throwable t) {
        }
    }
}

