/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.pref;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class YSharedPref {
    private static final String TAG = "YSharedPref";
    private static final String DELIMITER = ",";
    protected final SharedPreferences mPref;

    public YSharedPref(SharedPreferences pref) {
        this.mPref = pref;
    }

    public void putString(String key, String value) {
        this.put(key, value);
    }

    public String getString(String key) {
        return this.get(key);
    }

    public String getString(String key, String defaultValue) {
        return this.mPref.getString(key, defaultValue);
    }

    public void putInt(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(rawValue);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "failed to parse boolean value for key %s, %s", key, e);
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            return defaultValue;
        }
        return this.parseInt(rawValue, defaultValue);
    }

    private int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            MLog.error((Object)TAG, "lcy failed to parse value for key %s, %s", value, e);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public void putLong(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public long getLong(String key, long defaultValue) {
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(rawValue);
        }
        catch (NumberFormatException e) {
            MLog.error((Object)TAG, "lcy failed to parse %s as long, for key %s, ex : %s", rawValue, key, e);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public void putIntArray(String key, Integer[] values) {
        this.putIntList(key, Arrays.asList(values));
    }

    public int[] getIntArray(String key) {
        return this.getIntArray(key, null);
    }

    public int[] getIntArray(String key, int[] outValues) {
        List<Integer> list = this.getIntList(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        int[] ret = list.size() <= outValues.length ? outValues : new int[list.size()];
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    public void putIntList(String key, List<Integer> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        String value = TextUtils.join((CharSequence)DELIMITER, values);
        this.put(key, value);
    }

    public List<Integer> getIntList(String key) {
        String val = this.get(key);
        if (TextUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        String[] values = TextUtils.split((String)val, (String)DELIMITER);
        if (values == null || values.length == 0) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String e : values) {
            try {
                list.add(Integer.parseInt(e));
            }
            catch (NumberFormatException ex) {
                MLog.error((Object)this, "lcy failed to parse value for key: %s, value: %s, exception: %s", key, e, ex);
            }
        }
        return list;
    }

    public final void put(String key, String value) {
        this.mPref.edit().putString(key, value).apply();
    }

    public final String get(String key) {
        return this.mPref.getString(key, null);
    }

    public void remove(String key) {
        this.mPref.edit().remove(key).apply();
    }

    public void clear() {
        this.mPref.edit().clear().apply();
    }

    public Map<String, ?> getAll() {
        return this.mPref.getAll();
    }

    public boolean contain(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return this.mPref.contains(key);
    }

    public void putObject(String key, Object obj) {
        Gson gson = new Gson();
        String json = gson.toJson(obj);
        this.put(key, json);
    }

    public Object getObj(String key, Class className) {
        Gson gson = new Gson();
        String json = this.getString(key, "");
        Object obj = gson.fromJson(json, className);
        return obj;
    }
}

