/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.performance;

import android.os.Looper;
import android.os.SystemClock;
import com.yy.mobile.util.log.MLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Ticker {
    private static final String TAG = "Ticker#";
    private String mTickerId;
    private final Map<String, Pair> mTaskMap = new ConcurrentHashMap<String, Pair>();

    public Ticker(String id2) {
        this.mTickerId = id2;
    }

    public void startTask(String taskName, boolean printLog) {
        if (!this.isTaskExist(taskName)) {
            this.mTaskMap.put(taskName, new Pair(SystemClock.currentThreadTimeMillis()).markMainThread(Looper.myLooper() == Looper.getMainLooper()));
            if (printLog) {
                MLog.info(TAG + this.mTickerId, taskName + " start ", new Object[0]);
            }
        }
    }

    public void stopTask(String taskName, boolean printLog) {
        if (this.mTaskMap != null) {
            long stopTimeMillis = SystemClock.currentThreadTimeMillis();
            Pair pair = this.mTaskMap.get(taskName);
            if (pair != null) {
                long costTime = stopTimeMillis - pair.startTime;
                if (Looper.myLooper() != Looper.getMainLooper() || !pair.isMainThread) {
                    pair.isMainThread = false;
                }
                if (printLog) {
                    MLog.info(TAG + this.mTickerId, taskName + " end timecost = " + costTime, new Object[0]);
                }
                this.removeTask(taskName);
            }
        }
    }

    private void removeTask(String taskName) {
        if (this.mTaskMap != null) {
            this.mTaskMap.remove(taskName);
        }
    }

    public boolean isTaskExist(String taskName) {
        return this.mTaskMap != null && this.mTaskMap.get(taskName) != null;
    }

    static class Pair {
        long startTime;
        boolean isMainThread;

        public Pair(long startTime) {
            this.startTime = startTime;
        }

        public Pair markMainThread(boolean isMainThread) {
            this.isMainThread = isMainThread;
            return this;
        }
    }
}

