/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger.printer.writer;

import android.util.Log;
import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.log.logger.printer.AndroidPrinter;
import com.yy.mobile.util.log.logger.printer.writer.AbstractFileWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class BufferedFileWriter
extends AbstractFileWriter {
    private static final int BUFFER_SIZE = 4096;
    private static final int WRITE_GAP = 2000;
    private long mLastWriteMsgTime = -1L;
    private long mCurrentTime = 0L;
    private volatile boolean mNextForceFlush = false;

    public BufferedFileWriter() {
        this(null);
    }

    public BufferedFileWriter(Writer fileWriter) {
        super(fileWriter);
    }

    @Override
    public void writer(String msg, long msgTime) throws IOException {
        if (msg == null) {
            return;
        }
        super.writer(msg, msgTime);
        this.flushIfNeed(msgTime);
    }

    @Override
    public void writer(String msg) throws IOException {
        if (msg == null) {
            return;
        }
        super.writer(msg);
        this.flushIfNeed(System.currentTimeMillis());
    }

    @Override
    public void update(Writer fileWriter) {
        super.update(fileWriter);
        try {
            this.flushIfNeed(System.currentTimeMillis());
        }
        catch (IOException e) {
            Log.e((String)"BufferedFileWriter", (String)(" error ignore: " + e.getMessage()));
            PerfLog.webLog("mlog", "error ignore: " + e.getMessage());
        }
    }

    @Override
    public Writer createWrite(File file) throws IOException {
        MyFileWriter fileWriter = new MyFileWriter(new FileOutputStream(file, true));
        MyBufferedWriter writer = null;
        try {
            writer = new MyBufferedWriter(fileWriter, 4096, null);
        }
        catch (Exception e) {
            fileWriter.close();
            PerfLog.webLog("mlog", "createWrite error " + e.getMessage());
            throw new IOException("createWrite error");
        }
        return writer;
    }

    private void flushIfNeed(long time) throws IOException {
        if (!this.mUseBuffer) {
            this.flush();
            if (this.mNextForceFlush) {
                this.flush(true);
                this.mNextForceFlush = false;
            }
            return;
        }
        if (time < 0L) {
            time = System.currentTimeMillis();
        }
        this.mCurrentTime = time;
        if (this.mLastWriteMsgTime == -1L) {
            this.mLastWriteMsgTime = this.mCurrentTime;
        }
        if (this.mCurrentTime - this.mLastWriteMsgTime > 2000L || this.mCurrentTime - this.mLastWriteMsgTime < 0L) {
            this.mLastWriteMsgTime = this.mCurrentTime;
            this.flush();
        }
    }

    @Override
    public void setBuffered(boolean useBuffer) {
        super.setBuffered(useBuffer);
        if (!useBuffer) {
            this.mNextForceFlush = true;
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void flush(boolean forced) throws IOException {
        if (forced) {
            if (this.mFileWriter instanceof MyBufferedWriter) {
                ((MyBufferedWriter)this.mFileWriter).flushFroce();
            }
        } else {
            this.flush();
        }
    }

    public class MyFileWriter
    extends OutputStreamWriter {
        private FileOutputStream mMyOut;

        public MyFileWriter(FileOutputStream out) throws IOException {
            super(out);
            this.mMyOut = out;
        }

        @Override
        public void flush() throws IOException {
            FileDescriptor fd;
            super.flush();
            if (this.mMyOut != null && (fd = this.mMyOut.getFD()) != null) {
                fd.sync();
            }
        }

        public void flushForce() throws IOException {
            FileDescriptor fd;
            super.flush();
            if (this.mMyOut != null && (fd = this.mMyOut.getFD()) != null) {
                fd.sync();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException e) {
                PerfLog.webLog("mlog", "createWrite error " + e.getMessage());
                throw e;
            }
            catch (IllegalStateException e) {
                PerfLog.webLog("mlog", "MyFileWriter close error " + e.getMessage());
                AndroidPrinter.log("E/:", "MyFileWriter", e, " close error", new Object[0]);
            }
        }
    }

    private static class MyBufferedWriter
    extends Writer {
        private MyFileWriter out;
        private char[] cb;
        private int nChars;
        private int nextChar;
        private static int defaultCharBufferSize = 4096;

        public MyBufferedWriter(MyFileWriter out) {
            this(out, defaultCharBufferSize, null);
        }

        public MyBufferedWriter(MyFileWriter out, int sz, IFlushCallBack flushCallBack) {
            if (sz <= 0) {
                throw new IllegalArgumentException("Buffer size <= 0");
            }
            this.out = out;
            this.cb = new char[sz];
            this.nChars = sz;
            this.nextChar = 0;
        }

        public void flushFroce() throws IOException {
            this.out.flushForce();
        }

        void flushBuffer() throws IOException {
            if (this.nextChar == 0) {
                return;
            }
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
        }

        @Override
        public void write(int c) throws IOException {
            if (this.nextChar >= this.nChars) {
                this.flushBuffer();
            }
            this.cb[this.nextChar++] = (char)c;
        }

        private int min(int a, int b) {
            if (a < b) {
                return a;
            }
            return b;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.nChars) {
                this.flushBuffer();
                this.out.write(cbuf, off, len);
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                System.arraycopy(cbuf, b, this.cb, this.nextChar, d);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }

        @Override
        public void write(String s, int off, int len) throws IOException {
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                s.getChars(b, b + d, this.cb, this.nextChar);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }

        public void newLine() throws IOException {
            this.write(10);
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer();
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.out == null) {
                return;
            }
            try {
                this.flushBuffer();
            }
            finally {
                this.out.close();
                this.out = null;
                this.cb = null;
            }
        }

        static interface IFlushCallBack {
            public void onFlushed();
        }
    }
}

