/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger.printer.transformation;

import java.util.concurrent.TimeUnit;

public class YYLogDateFormat {
    private static final long ONE_SECOND = 1000L;
    private static final long MAX_SECOND_NUM = 60L;
    private static final long ONE_MINUTE = 60000L;
    private static final long MAX_MINUTE_NUM = 60L;
    private static final long ONE_HOUR = 3600000L;
    private static final long MAX_HOUR_NUM = 24L;
    private static final long DIFF_HOURS = 8L;
    private static final int CAPACITY = 12;
    private static final long ONE_DAY = 86400000L;
    private static final String MAIN_SPLITTER = ":";
    private static final String MINOR_SPLITTER = ".";
    private static final String ZERO = "0";
    private static final String DOUBLE_ZERO = "00";

    public String format(long time) {
        long timeInDay = time % 86400000L;
        long hours = (TimeUnit.MILLISECONDS.toHours(timeInDay) + 8L) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timeInDay) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(timeInDay) % 60L;
        long microSeconds = timeInDay % 1000L;
        StringBuilder stringBuilder = new StringBuilder(12);
        if (hours < 10L) {
            stringBuilder.append(ZERO);
        }
        stringBuilder.append(hours);
        stringBuilder.append(MAIN_SPLITTER);
        if (minutes < 10L) {
            stringBuilder.append(ZERO);
        }
        stringBuilder.append(minutes);
        stringBuilder.append(MAIN_SPLITTER);
        if (seconds < 10L) {
            stringBuilder.append(ZERO);
        }
        stringBuilder.append(seconds);
        stringBuilder.append(MINOR_SPLITTER);
        if (microSeconds < 100L) {
            if (microSeconds < 10L) {
                stringBuilder.append(DOUBLE_ZERO);
            } else {
                stringBuilder.append(ZERO);
            }
        }
        stringBuilder.append(microSeconds);
        return stringBuilder.toString();
    }
}

