/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.javascript;

import android.webkit.JavascriptInterface;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.ApiModuleManager;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import org.jetbrains.annotations.NotNull;

public class JSInterface {
    public static final String TAG = "JSInterface";
    public static final String INVOKE_WEB_METHOD = "javascript:try{window.YYApiCore.invokeWebMethod('%s',JSON.parse(%s))}catch(e){if(console)console.log(e)}";
    private ApiModuleManager v2ApiModuleManager = new ApiModuleManager();
    private final ICallBack mCallback;

    public JSInterface(@NotNull ICallBack callback) {
        this.mCallback = callback;
    }

    public void addApiModule(IApiModule module) {
        this.v2ApiModuleManager.addModule(module);
    }

    public void removeApiModule(String moduleName) {
        this.v2ApiModuleManager.removeModuleByName(moduleName);
    }

    public void release() {
        this.v2ApiModuleManager.release();
    }

    @JavascriptInterface
    public String invoke(String module, String name, String parameters, String callback) {
        try {
            IApiModule apiModule = this.v2ApiModuleManager.getModule(module);
            if (apiModule != null) {
                return apiModule.invoke(name, parameters, new JSCallbackAdapter(callback, this.mCallback));
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "invoke module = " + module + ", name = " + name + ", parameters = " + parameters + ", error happen e = " + e, e, new Object[0]);
        }
        return JsonParser.toJson(new ResultData(-1));
    }

    public static interface ICallBack {
        public void invoke(String var1);
    }

    private static class JSCallbackAdapter
    implements IApiModule.IJSCallback {
        private final String callbackName;
        private final ICallBack method;

        private JSCallbackAdapter(String callbackName, ICallBack method) {
            this.callbackName = callbackName;
            this.method = method;
        }

        @Override
        public void invokeCallback(String param) {
            this.method.invoke(String.format(JSInterface.INVOKE_WEB_METHOD, this.callbackName, param));
        }
    }
}

