/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.instanceinject;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.util.SparseArray;
import com.yy.mobile.util.instanceinject.SavedState;
import com.yy.mobile.util.log.MLog;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class InstanceStateInjectUtil {
    public static void saveInstanceState(Fragment mContext, Bundle outState) {
        Class<?> cls = mContext.getClass();
        Field[] fields = cls.getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                String key = InstanceStateInjectUtil.generateKey(mContext, field.getName());
                Object value = field.get(mContext);
                if (field.getAnnotation(SavedState.class) == null) continue;
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug("inject", "inject save instance=" + field.getName(), new Object[0]);
                }
                Class<?> type = field.getType();
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)genericType;
                    Type[] argTypes = parameterizedType.getActualTypeArguments();
                    Class c2 = (Class)argTypes[0];
                    if (parameterizedType.getRawType().toString().equals("class java.util.ArrayList")) {
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug("inject", "save arrayList", new Object[0]);
                        }
                        if (genericType.toString().equals("java.util.ArrayList<java.lang.Integer>")) {
                            outState.putIntegerArrayList(key, (ArrayList)value);
                            continue;
                        }
                        if (genericType.toString().equals("java.util.ArrayList<java.lang.String>")) {
                            outState.putStringArrayList(key, (ArrayList)value);
                            continue;
                        }
                        if (genericType.toString().equals("java.util.ArrayList<java.lang.CharSequence>")) {
                            outState.putCharSequenceArrayList(key, (ArrayList)value);
                            continue;
                        }
                        if (!c2.getSuperclass().isAssignableFrom(Parcelable.class)) continue;
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug("inject", "save arrayList parcelable", new Object[0]);
                        }
                        outState.putParcelableArrayList(key, (ArrayList)value);
                        continue;
                    }
                    if (!parameterizedType.getRawType().toString().equals("class android.util.SparseArray") || !c2.getSuperclass().isAssignableFrom(Parcelable.class)) continue;
                    outState.putSparseParcelableArray(key, (SparseArray)value);
                    continue;
                }
                if (type.isPrimitive()) {
                    if (type.equals(Integer.TYPE)) {
                        outState.putInt(key, ((Integer)value).intValue());
                        continue;
                    }
                    if (type.equals(Character.TYPE)) {
                        outState.putChar(key, ((Character)value).charValue());
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        outState.putBoolean(key, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (type.equals(Byte.TYPE)) {
                        outState.putByte(key, ((Byte)value).byteValue());
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        outState.putLong(key, ((Long)value).longValue());
                        continue;
                    }
                    if (type.equals(Float.TYPE)) {
                        outState.putFloat(key, ((Float)value).floatValue());
                        continue;
                    }
                    if (type.equals(Double.TYPE)) {
                        outState.putDouble(key, ((Double)value).doubleValue());
                        continue;
                    }
                    if (!type.equals(Short.TYPE)) continue;
                    outState.putShort(key, ((Short)value).shortValue());
                    continue;
                }
                if (type.isArray()) {
                    Class<?> argType = type.getComponentType();
                    if (argType.equals(Integer.TYPE)) {
                        outState.putIntArray(key, (int[])value);
                        continue;
                    }
                    if (argType.equals(Character.TYPE)) {
                        outState.putCharArray(key, (char[])value);
                        continue;
                    }
                    if (argType.equals(Boolean.TYPE)) {
                        outState.putBooleanArray(key, (boolean[])value);
                        continue;
                    }
                    if (argType.equals(Byte.TYPE)) {
                        outState.putByteArray(key, (byte[])value);
                        continue;
                    }
                    if (argType.equals(Long.TYPE)) {
                        outState.putLongArray(key, (long[])value);
                        continue;
                    }
                    if (argType.equals(Float.TYPE)) {
                        outState.putFloatArray(key, (float[])value);
                        continue;
                    }
                    if (argType.equals(Double.TYPE)) {
                        outState.putDoubleArray(key, (double[])value);
                        continue;
                    }
                    if (argType.equals(Short.TYPE)) {
                        outState.putShortArray(key, (short[])value);
                        continue;
                    }
                    if (!argType.equals(Parcelable.class)) continue;
                    outState.putParcelable(key, (Parcelable)value);
                    continue;
                }
                if (type.equals(String.class)) {
                    outState.putString(key, (String)value);
                    continue;
                }
                if (type.equals(CharSequence.class)) {
                    outState.putCharSequence(key, (CharSequence)value);
                    continue;
                }
                if (type.equals(Bundle.class)) {
                    outState.putAll((Bundle)value);
                    continue;
                }
                if (value instanceof Serializable) {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug(mContext, "state inject serializable", new Object[0]);
                    }
                    outState.putSerializable(key, (Serializable)value);
                    continue;
                }
                if (!(value instanceof Parcelable)) continue;
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(mContext, "state inject Parcelable", new Object[0]);
                }
                outState.putParcelable(key, (Parcelable)value);
            }
        }
        catch (Exception e) {
            MLog.error(mContext, e);
        }
    }

    public static void restoreInstanceState(Fragment mContext, Bundle outState) {
        if (outState == null) {
            return;
        }
        Class<?> cls = mContext.getClass();
        Field[] fields = cls.getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                String key = InstanceStateInjectUtil.generateKey(mContext, field.getName());
                if (field.getAnnotation(SavedState.class) == null) continue;
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(mContext, "restore instance", new Object[0]);
                }
                Class<?> type = field.getType();
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    Object tmp;
                    ParameterizedType parameterizedType = (ParameterizedType)genericType;
                    Type[] argTypes = parameterizedType.getActualTypeArguments();
                    Class c2 = (Class)argTypes[0];
                    if (parameterizedType.getRawType().toString().equals("class java.util.ArrayList")) {
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug("inject", "restore arrayList", new Object[0]);
                        }
                        if (genericType.toString().equals("java.util.ArrayList<java.lang.Integer>")) {
                            field.set(mContext, outState.getIntegerArrayList(key));
                            continue;
                        }
                        if (genericType.toString().equals("java.util.ArrayList<java.lang.String>")) {
                            field.set(mContext, outState.getStringArrayList(key));
                            continue;
                        }
                        if (genericType.toString().equals("java.util.ArrayList<java.lang.CharSequence>")) {
                            field.set(mContext, outState.getCharSequenceArrayList(key));
                            continue;
                        }
                        if (!c2.getSuperclass().isAssignableFrom(Parcelable.class)) continue;
                        tmp = outState.getParcelableArrayList(key);
                        if (field.get(mContext) == null) continue;
                        ((ArrayList)field.get(mContext)).addAll(tmp);
                        continue;
                    }
                    if (!parameterizedType.getRawType().toString().equals("class android.util.SparseArray") || !c2.getSuperclass().isAssignableFrom(Parcelable.class)) continue;
                    tmp = outState.getSparseParcelableArray(key);
                    if (field.get(mContext) == null) continue;
                    SparseArray sparseArray = (SparseArray)field.get(mContext);
                    for (int i = 0; i < tmp.size(); ++i) {
                        sparseArray.put(tmp.keyAt(i), tmp.valueAt(i));
                    }
                    continue;
                }
                if (type.isPrimitive()) {
                    if (type.equals(Integer.TYPE)) {
                        field.set(mContext, outState.getInt(key));
                        continue;
                    }
                    if (type.equals(Character.TYPE)) {
                        field.set(mContext, Character.valueOf(outState.getChar(key)));
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        field.set(mContext, outState.getBoolean(key));
                        continue;
                    }
                    if (type.equals(Byte.TYPE)) {
                        field.set(mContext, outState.getByte(key));
                        continue;
                    }
                    if (type.equals(Long.TYPE)) {
                        field.set(mContext, outState.getLong(key));
                        continue;
                    }
                    if (type.equals(Float.TYPE)) {
                        field.set(mContext, Float.valueOf(outState.getFloat(key)));
                        continue;
                    }
                    if (type.equals(Double.TYPE)) {
                        field.set(mContext, outState.getDouble(key));
                        continue;
                    }
                    if (!type.equals(Short.TYPE)) continue;
                    field.set(mContext, outState.getShort(key));
                    continue;
                }
                if (type.isArray()) {
                    Class<?> argType = type.getComponentType();
                    if (argType.equals(Integer.TYPE)) {
                        field.set(mContext, outState.getIntArray(key));
                        continue;
                    }
                    if (argType.equals(Character.TYPE)) {
                        field.set(mContext, outState.getCharArray(key));
                        continue;
                    }
                    if (argType.equals(Boolean.TYPE)) {
                        field.set(mContext, outState.getBooleanArray(key));
                        continue;
                    }
                    if (argType.equals(Byte.TYPE)) {
                        field.set(mContext, outState.getByteArray(key));
                        continue;
                    }
                    if (argType.equals(Long.TYPE)) {
                        field.set(mContext, outState.getLongArray(key));
                        continue;
                    }
                    if (argType.equals(Float.TYPE)) {
                        field.set(mContext, outState.getFloatArray(key));
                        continue;
                    }
                    if (argType.equals(Double.TYPE)) {
                        field.set(mContext, outState.getDoubleArray(key));
                        continue;
                    }
                    if (argType.equals(Short.TYPE)) {
                        field.set(mContext, outState.getShortArray(key));
                        continue;
                    }
                    if (!argType.equals(Parcelable.class)) continue;
                    field.set(mContext, outState.getParcelableArray(key));
                    continue;
                }
                if (type.equals(String.class)) {
                    field.set(mContext, outState.getString(key));
                    continue;
                }
                if (type.equals(CharSequence.class)) {
                    field.set(mContext, outState.getCharSequence(key));
                    continue;
                }
                if (type.equals(Bundle.class)) {
                    field.set(mContext, outState.getBundle(key));
                    continue;
                }
                if (outState.getSerializable(key) instanceof Serializable) {
                    field.set(mContext, outState.getSerializable(key));
                    continue;
                }
                if (!(outState.getParcelable(key) instanceof Parcelable)) continue;
                field.set(mContext, outState.getParcelable(key));
            }
        }
        catch (Exception e) {
            MLog.error(mContext, e);
        }
    }

    private static String generateKey(Fragment context, String name) {
        return context.getClass().getSimpleName() + "_" + name;
    }
}

