/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.gif;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.DynamicDrawableSpan;
import com.yy.mobile.util.gif.AnimatedGifDrawable;
import com.yy.mobile.util.log.MLog;

public class AnimatedImageSpan
extends DynamicDrawableSpan {
    private static final String TAG = "AnimatedImageSpan";
    private AnimatedGifDrawable mDrawable;
    public int position;
    Runnable task = new Runnable(){

        @Override
        public void run() {
            if (AnimatedImageSpan.this.mDrawable == null) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug(AnimatedImageSpan.TAG, "mDrawable==null", new Object[0]);
                }
                return;
            }
            AnimatedImageSpan.this.mDrawable.nextFrame();
            AnimatedImageSpan.this.mDrawable.getHandler().postDelayed(this, AnimatedImageSpan.this.mDrawable.getFrameDuration());
        }
    };

    public AnimatedImageSpan(AnimatedGifDrawable d) {
        if (d == null) {
            return;
        }
        this.mDrawable = d;
        this.start();
    }

    public void start() {
        this.mDrawable.getHandler().removeCallbacks(this.task);
        this.mDrawable.getHandler().post(this.task);
    }

    public void stop() {
        if (this.mDrawable != null) {
            this.mDrawable.stop();
        }
    }

    public Drawable getDrawable() {
        if (this.mDrawable == null) {
            return null;
        }
        return this.mDrawable.getDrawable();
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        Drawable d = this.getDrawable();
        if (d == null) {
            return 0;
        }
        Rect rect = d.getBounds();
        if (fm != null) {
            fm.ascent = -rect.bottom;
            fm.descent = 0;
            fm.top = fm.ascent;
            fm.bottom = 0;
        }
        return rect.right;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Drawable b = this.getDrawable();
        if (b == null) {
            return;
        }
        canvas.save();
        int transY = bottom - b.getBounds().bottom;
        if (this.mVerticalAlignment == 1) {
            transY -= paint.getFontMetricsInt().descent;
        }
        canvas.translate(x, (float)transY);
        b.draw(canvas);
        canvas.restore();
    }
}

