/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.Context;
import android.util.Log;
import com.yy.mobile.framework.R;
import com.yy.mobile.util.log.MLog;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.IllegalFormatException;

public class TimeUtils {
    public static final long MONTHS_OF_YEAR = 12L;
    public static final long DAYS_OF_YEAR = 365L;
    public static final long DAYS_OF_MONTH = 30L;
    public static final long HOURS_OF_DAY = 24L;
    public static final long MINUTES_OF_HOUR = 60L;
    public static final long SECONDS_OF_MINUTE = 60L;
    public static final long MILLIS_OF_SECOND = 1000L;

    public static boolean isSameDay(long millis1, long millis2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(millis1);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(millis2);
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    public static boolean isSameWeek(long millis1, long millis2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(millis1);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(millis2);
        return c1.get(1) == c2.get(1) && c1.get(3) == c2.get(3);
    }

    public static int getYear(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(1);
    }

    public static int getMonth(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(2) + 1;
    }

    public static int getDayOfMonth(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(5);
    }

    public static int getDayOfWeek(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(7);
    }

    public static int getHourOf12HClock(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(10);
    }

    public static int getHourOf24HClock(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(11);
    }

    public static int getMinute(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(12);
    }

    public static int getSecond(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c.get(13);
    }

    public static long getExpireDeadTime(long millisToExpire) {
        return System.currentTimeMillis() + millisToExpire;
    }

    public static String getTimeStringFromMillis(long timeMillis) {
        String format = "%04d-%02d-%02d %02d:%02d:%2d";
        return TimeUtils.getTimeStringFromMillis(timeMillis, format);
    }

    public static String getTimeStringFromMillis(long timeMillis, String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String timeString = null;
        try {
            timeString = String.format(format, year, month, day, hour, min, sec);
        }
        catch (IllegalFormatException e) {
            Log.e((String)"TimeUtils", (String)"printStackTrace", (Throwable)e);
        }
        return timeString;
    }

    public static String getFormatTimeString(long timeMillis, String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String timeString = null;
        try {
            timeString = format.replaceAll("year", String.valueOf(year)).replaceAll("mon", month < 10 ? "0" + month : "" + month).replaceAll("day", day < 10 ? "0" + day : "" + day).replaceAll("hour", hour < 10 ? "0" + hour : "" + hour).replaceAll("min", min < 10 ? "0" + min : "" + min).replaceAll("sec", sec < 10 ? "0" + sec : "" + sec);
        }
        catch (Exception e) {
            MLog.error((Object)"TimeUtils", "getFormatTimeString error! " + e.toString(), new Object[0]);
        }
        return timeString;
    }

    public static String getPostTimeString(Context context, long timeMillis, boolean showToday, boolean showSecond) {
        if (context == null) {
            return null;
        }
        String sSpace = " ";
        String sToday = context.getString(R.string.str_today);
        String sYesterday = context.getString(R.string.str_yesterday);
        String sBeforeYesterday = context.getString(R.string.str_day_before_yesterday);
        String sShortDateFormat = context.getString(R.string.str_short_date_format);
        String sDateFormat = context.getString(R.string.str_date_format);
        Calendar current = Calendar.getInstance();
        Calendar post = Calendar.getInstance();
        current.setTimeInMillis(System.currentTimeMillis());
        post.setTimeInMillis(timeMillis);
        int diffDays = current.get(6) - post.get(6);
        boolean isSameYear = post.get(1) == current.get(1);
        StringBuilder builder = new StringBuilder();
        if (diffDays > 0 || !isSameYear) {
            if (diffDays > 0 && diffDays <= 2) {
                builder.append(diffDays == 1 ? sYesterday : sBeforeYesterday);
                builder.append(sSpace);
            } else if (isSameYear) {
                builder.append(String.format(sShortDateFormat, post.get(2) + 1, post.get(5)));
                builder.append(sSpace);
            } else {
                builder.append(String.format(sDateFormat, post.get(1), post.get(2) + 1, post.get(5)));
                builder.append(sSpace);
            }
        } else if (showToday) {
            builder.append(sToday);
            builder.append(sSpace);
        }
        if (showSecond) {
            builder.append(String.format(context.getString(R.string.str_time_format), post.get(11), post.get(12), post.get(13)));
        } else {
            builder.append(String.format(context.getString(R.string.str_short_time_format), post.get(11), post.get(12)));
        }
        return builder.toString();
    }

    private static long checkOverflow(long t, long scale) {
        if (t > Long.MAX_VALUE / scale) {
            return Long.MAX_VALUE;
        }
        if (t < Long.MIN_VALUE / scale) {
            return Long.MIN_VALUE;
        }
        return t * scale;
    }

    public static Long convertTimeToLong(String time) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(time);
            return date.getTime();
        }
        catch (Exception e) {
            MLog.error("TimeUtils", e);
            return 0L;
        }
    }

    public static int curSec() {
        long l = System.currentTimeMillis();
        return (int)(l / 1000L);
    }

    public static class MILLIS {
        public static long toSeconds(long millis) {
            return millis / 1000L;
        }

        public static long toMinutes(long millis) {
            return MILLIS.toSeconds(millis) / 60L;
        }

        public static long toHours(long millis) {
            return MILLIS.toMinutes(millis) / 60L;
        }

        public static long toDays(long millis) {
            return MILLIS.toHours(millis) / 24L;
        }

        public static long toMonths(long millis) {
            return MILLIS.toDays(millis) / 30L;
        }

        public static long toYears(long millis) {
            return MILLIS.toDays(millis) / 365L;
        }
    }

    public static class SECONDS {
        public static long toMillis(long seconds) {
            return TimeUtils.checkOverflow(seconds, 1000L);
        }

        public static long toMinutes(long seconds) {
            return seconds / 60L;
        }

        public static long toHours(long seconds) {
            return SECONDS.toMinutes(seconds) / 60L;
        }

        public static long toDays(long seconds) {
            return SECONDS.toHours(seconds) / 24L;
        }

        public static long toMonths(long seconds) {
            return SECONDS.toDays(seconds) / 30L;
        }

        public static long toYears(long seconds) {
            return SECONDS.toDays(seconds) / 365L;
        }
    }

    public static class MINUTES {
        public static long toMillis(long minutes) {
            return TimeUtils.checkOverflow(minutes, 60000L);
        }

        public static long toSeconds(long minutes) {
            return TimeUtils.checkOverflow(minutes, 60L);
        }

        public static long toHours(long minutes) {
            return minutes / 60L;
        }

        public static long toDays(long minutes) {
            return MINUTES.toHours(minutes) / 24L;
        }

        public static long toMonths(long minutes) {
            return MINUTES.toDays(minutes) / 30L;
        }

        public static long toYears(long minutes) {
            return MINUTES.toDays(minutes) / 365L;
        }
    }

    public static class HOURS {
        public static long toMillis(long hours) {
            return TimeUtils.checkOverflow(hours, 3600000L);
        }

        public static long toSeconds(long hours) {
            return TimeUtils.checkOverflow(hours, 3600L);
        }

        public static long toMinutes(long hours) {
            return TimeUtils.checkOverflow(hours, 60L);
        }

        public static long toDays(long hours) {
            return hours / 24L;
        }

        public static long toMonths(long hours) {
            return HOURS.toDays(hours) / 30L;
        }

        public static long toYears(long hours) {
            return HOURS.toDays(hours) / 365L;
        }
    }

    public static class DAYS {
        public static long toMillis(long days) {
            return TimeUtils.checkOverflow(days, 86400000L);
        }

        public static long toSeconds(long days) {
            return TimeUtils.checkOverflow(days, 86400L);
        }

        public static long toMinutes(long days) {
            return TimeUtils.checkOverflow(days, 1440L);
        }

        public static long toHours(long days) {
            return TimeUtils.checkOverflow(days, 24L);
        }

        public static long toMonths(long days) {
            return days / 30L;
        }

        public static long toYears(long days) {
            return days / 365L;
        }
    }

    public static class MONTHS {
        public static long toMillis(long months) {
            return TimeUtils.checkOverflow(months, 2592000000L);
        }

        public static long toSeconds(long months) {
            return TimeUtils.checkOverflow(months, 2592000L);
        }

        public static long toMinutes(long months) {
            return TimeUtils.checkOverflow(months, 43200L);
        }

        public static long toHours(long months) {
            return TimeUtils.checkOverflow(months, 720L);
        }

        public static long toDays(long months) {
            return TimeUtils.checkOverflow(months, 30L);
        }

        public static long toYears(long months) {
            return months / 12L;
        }
    }

    public static class YEARS {
        public static long toMillis(long years) {
            return TimeUtils.checkOverflow(years, 31536000000L);
        }

        public static long toSeconds(long years) {
            return TimeUtils.checkOverflow(years, 31536000L);
        }

        public static long toMinutes(long years) {
            return TimeUtils.checkOverflow(years, 525600L);
        }

        public static long toHours(long years) {
            return TimeUtils.checkOverflow(years, 8760L);
        }

        public static long toDays(long years) {
            return TimeUtils.checkOverflow(years, 365L);
        }

        public static long toMonths(long years) {
            return TimeUtils.checkOverflow(years, 12L);
        }
    }
}

