/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;

public class ResolutionUtils {
    public static int getScreenWidth(Context context) {
        return ResolutionUtils.getScreenSize((Context)context, null).x;
    }

    public static int getScreenHeight(Context context) {
        return ResolutionUtils.getScreenSize((Context)context, null).y;
    }

    public static Point getScreenSize(Context context, Point outSize) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point ret = outSize == null ? new Point() : outSize;
        Display defaultDisplay = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            defaultDisplay.getSize(ret);
        } else {
            ret.x = defaultDisplay.getWidth();
            ret.y = defaultDisplay.getHeight();
        }
        return ret;
    }

    public static float convertDpToPixel(float dp, Context context) {
        try {
            if (context == null) {
                return dp;
            }
            Resources resources = context.getResources();
            DisplayMetrics metrics = resources.getDisplayMetrics();
            float px = dp * ((float)metrics.densityDpi / 160.0f);
            return px;
        }
        catch (Exception ex) {
            Log.e((String)"ResolutionUtils", (String)"Empty Catch on convertDpToPixel", (Throwable)ex);
            return -1.0f;
        }
    }

    public static float convertPixelsToDp(float px, Context context) {
        try {
            if (context == null) {
                return px;
            }
            Resources resources = context.getResources();
            DisplayMetrics metrics = resources.getDisplayMetrics();
            float dp = px / ((float)metrics.densityDpi / 160.0f);
            return dp;
        }
        catch (Exception ex) {
            Log.e((String)"ResolutionUtils", (String)"Empty Catch on convertPixelsToDp", (Throwable)ex);
            return -1.0f;
        }
    }

    public static float getScreenWidthHeightRatio(Context context, Point outSize) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point ret = outSize == null ? new Point() : outSize;
        Display defaultDisplay = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            defaultDisplay.getSize(ret);
        } else {
            ret.x = defaultDisplay.getWidth();
            ret.y = defaultDisplay.getHeight();
        }
        float xf = ret.x;
        float yf = ret.y;
        return xf / yf;
    }
}

