/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.CopyOnWriteArraySet;

public class NetworkMonitor
extends BroadcastReceiver {
    private static final String TAG = "NetworkMonitor";
    public static final int INVALID_TYPE = -1;
    boolean mInit = false;
    private CopyOnWriteArraySet<OnNetworkChange> mListener = new CopyOnWriteArraySet();
    private static final NetworkMonitor sInstance = new NetworkMonitor();

    public static NetworkMonitor instance() {
        return sInstance;
    }

    private NetworkMonitor() {
    }

    public void init(Context context) {
        if (!this.mInit) {
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver((BroadcastReceiver)this, filter);
            this.mInit = true;
        }
    }

    public void addListener(OnNetworkChange l) {
        if (l != null) {
            this.mListener.add(l);
        }
    }

    public void removeListener(OnNetworkChange l) {
        this.mListener.remove(l);
    }

    public void onReceive(Context context, Intent intent) {
        block10: {
            if (this.mListener.isEmpty()) {
                MLog.warn(TAG, "NetworkMonitor.onReceive, mListener is empty", new Object[0]);
                return;
            }
            if (!intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) break block10;
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isAvailable()) {
                Log.i((String)"dingning", (String)"NetworkMonitor.onReceive, disconnected");
                MLog.warn(TAG, "NetworkMonitor.onReceive, disconnected", new Object[0]);
                for (OnNetworkChange l : this.mListener) {
                    l.onDisconnected(networkInfo != null ? networkInfo.getType() : -1);
                }
                return;
            }
            int type = networkInfo.getType();
            if (networkInfo.isConnected()) {
                Log.i((String)"dingning", (String)("NetworkMonitor.onReceive, connected, type = " + type));
                MLog.warn(TAG, "NetworkMonitor.onReceive, connected, type = %d", type);
                for (OnNetworkChange l : this.mListener) {
                    l.onConnected(type);
                }
            } else {
                boolean connecting = networkInfo.isConnectedOrConnecting();
                if (connecting) {
                    Log.i((String)"dingning", (String)"NetworkMonitor.onReceive, connecting");
                    MLog.warn(TAG, "NetworkMonitor.onReceive, connecting, type = %d", type);
                    for (OnNetworkChange l : this.mListener) {
                        l.onConnecting(type);
                    }
                } else {
                    Log.i((String)"dingning", (String)"NetworkMonitor.onReceive, disconnected");
                    MLog.warn(TAG, "NetworkMonitor.onReceive, disconnected, type = %d", type);
                    for (OnNetworkChange l : this.mListener) {
                        l.onDisconnected(type);
                    }
                }
            }
        }
    }

    public static interface OnNetworkChange {
        public void onDisconnected(int var1);

        public void onConnected(int var1);

        public void onConnecting(int var1);
    }
}

