/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.toast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.view.View;
import com.yy.mobile.ui.widget.toast.BadTokenListener;
import com.yy.mobile.ui.widget.toast.SafeToastContext;
import java.lang.reflect.Field;

@SuppressLint(value={"ShowToast", "ToastUsage"})
public class Toast
extends android.widget.Toast {
    @NonNull
    private final android.widget.Toast toast;

    public Toast(Context context) {
        super(context.getApplicationContext());
        this.toast = Toast.makeText(context.getApplicationContext(), "", 0);
    }

    public Toast(Context context, @NonNull android.widget.Toast base) {
        super(context.getApplicationContext());
        this.toast = base;
    }

    public static Toast makeText(Context context, CharSequence text, int duration) {
        android.widget.Toast toast = android.widget.Toast.makeText((Context)context.getApplicationContext(), (CharSequence)text, (int)duration);
        Toast.setContextCompat(toast.getView(), (Context)new SafeToastContext(context, toast));
        return new Toast(context, toast);
    }

    public static Toast makeText(Context context, @StringRes int resId, int duration) throws Resources.NotFoundException {
        return Toast.makeText(context, context.getResources().getText(resId), duration);
    }

    @NonNull
    public Toast setBadTokenListener(@NonNull BadTokenListener listener) {
        Context context = this.getView().getContext();
        if (context instanceof SafeToastContext) {
            ((SafeToastContext)context).setBadTokenListener(listener);
        }
        return this;
    }

    public void show() {
        this.toast.show();
    }

    public void setDuration(int duration) {
        this.toast.setDuration(duration);
    }

    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.toast.setGravity(gravity, xOffset, yOffset);
    }

    public void setMargin(float horizontalMargin, float verticalMargin) {
        this.toast.setMargin(horizontalMargin, verticalMargin);
    }

    public void setText(int resId) {
        this.toast.setText(resId);
    }

    public void setText(CharSequence s) {
        this.toast.setText(s);
    }

    public void setView(View view) {
        this.toast.setView(view);
        Toast.setContextCompat(view, (Context)new SafeToastContext(view.getContext(), this));
    }

    public float getHorizontalMargin() {
        return this.toast.getHorizontalMargin();
    }

    public float getVerticalMargin() {
        return this.toast.getVerticalMargin();
    }

    public int getDuration() {
        return this.toast.getDuration();
    }

    public int getGravity() {
        return this.toast.getGravity();
    }

    public int getXOffset() {
        return this.toast.getXOffset();
    }

    public int getYOffset() {
        return this.toast.getYOffset();
    }

    public void cancel() {
        this.toast.cancel();
    }

    public View getView() {
        return this.toast.getView();
    }

    @NonNull
    public android.widget.Toast getBaseToast() {
        return this.toast;
    }

    private static void setContextCompat(@NonNull View view, @NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 25) {
            try {
                Field field = View.class.getDeclaredField("mContext");
                field.setAccessible(true);
                field.set(view, context);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

