/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.span;

import android.content.Context;
import android.text.Spanned;
import android.util.AttributeSet;
import android.widget.TextView;
import com.yy.mobile.memoryrecycle.views.YYTextView;

public class SpanTextView
extends YYTextView {
    private boolean hasSpanCallback = false;
    private boolean isSpanAttached = false;
    private SpanCallback[] spanCallbacks;

    public SpanTextView(Context context) {
        super(context);
    }

    public SpanTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SpanTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onAttach();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDetach();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.onDetach();
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.onAttach();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        boolean wasSpanAttached = this.isSpanAttached;
        if (this.hasSpanCallback && wasSpanAttached) {
            this.onDetach();
        }
        if (text instanceof Spanned) {
            this.spanCallbacks = (SpanCallback[])((Spanned)text).getSpans(0, text.length(), SpanCallback.class);
            this.hasSpanCallback = this.spanCallbacks.length > 0;
        } else {
            this.spanCallbacks = null;
            this.hasSpanCallback = false;
        }
        super.setText(text, type);
        if (this.hasSpanCallback && wasSpanAttached) {
            this.onAttach();
        }
    }

    private void onAttach() {
        if (this.spanCallbacks != null) {
            for (SpanCallback callback : this.spanCallbacks) {
                callback.onAttach((TextView)this);
            }
        }
        this.isSpanAttached = true;
    }

    private void onDetach() {
        if (this.spanCallbacks != null) {
            for (SpanCallback callback : this.spanCallbacks) {
                callback.onDetach();
            }
        }
        this.isSpanAttached = false;
    }

    public static interface SpanCallback {
        public void onAttach(TextView var1);

        public void onDetach();
    }
}

