/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.menudrawer.compat;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.yy.mobile.ui.widget.menudrawer.compat.ActionBarHelperCompat;
import com.yy.mobile.ui.widget.menudrawer.compat.ActionBarHelperNative;
import java.lang.reflect.Method;

public final class ActionBarHelper {
    private static final String TAG = "ActionBarHelper";
    static final boolean DEBUG = false;
    private Activity mActivity;
    private Object mIndicatorInfo;
    private boolean mUsesCompat;

    public ActionBarHelper(Activity activity) {
        this.mActivity = activity;
        try {
            Class<?> clazz = activity.getClass();
            Method m = clazz.getMethod("getSupportActionBar", new Class[0]);
            this.mUsesCompat = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.mIndicatorInfo = this.getIndicatorInfo();
    }

    private Object getIndicatorInfo() {
        if (this.mUsesCompat && Build.VERSION.SDK_INT < 14) {
            return ActionBarHelperCompat.getIndicatorInfo(this.mActivity);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            return ActionBarHelperNative.getIndicatorInfo(this.mActivity);
        }
        return null;
    }

    public void setActionBarUpIndicator(Drawable drawable2, int contentDesc) {
        if (this.mUsesCompat && Build.VERSION.SDK_INT < 14) {
            ActionBarHelperCompat.setActionBarUpIndicator(this.mIndicatorInfo, this.mActivity, drawable2, contentDesc);
        } else if (Build.VERSION.SDK_INT >= 11) {
            ActionBarHelperNative.setActionBarUpIndicator(this.mIndicatorInfo, this.mActivity, drawable2, contentDesc);
        }
    }

    public void setActionBarDescription(int contentDesc) {
        if (this.mUsesCompat && Build.VERSION.SDK_INT < 14) {
            ActionBarHelperCompat.setActionBarDescription(this.mIndicatorInfo, this.mActivity, contentDesc);
        } else if (Build.VERSION.SDK_INT >= 11) {
            ActionBarHelperNative.setActionBarDescription(this.mIndicatorInfo, this.mActivity, contentDesc);
        }
    }

    public Drawable getThemeUpIndicator() {
        if (this.mUsesCompat && Build.VERSION.SDK_INT < 14) {
            return ActionBarHelperCompat.getThemeUpIndicator(this.mIndicatorInfo);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            return ActionBarHelperNative.getThemeUpIndicator(this.mIndicatorInfo, this.mActivity);
        }
        return null;
    }

    public void setDisplayShowHomeAsUpEnabled(boolean enabled) {
        if (this.mUsesCompat && Build.VERSION.SDK_INT < 14) {
            ActionBarHelperCompat.setDisplayHomeAsUpEnabled(this.mIndicatorInfo, enabled);
        } else if (Build.VERSION.SDK_INT >= 11) {
            ActionBarHelperNative.setDisplayHomeAsUpEnabled(this.mActivity, enabled);
        }
    }
}

