/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.datetimepicker;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.widget.datetimepicker.DatePickerController;
import com.yy.mobile.ui.widget.datetimepicker.DatePickerDialog;
import com.yy.mobile.ui.widget.datetimepicker.TextViewWithCircularIndicator;
import java.util.ArrayList;
import java.util.List;

public class YearPickerView
extends ListView
implements AdapterView.OnItemClickListener,
DatePickerDialog.OnDateChangedListener {
    private YearAdapter mAdapter;
    private int mChildSize;
    private final DatePickerController mController;
    private TextViewWithCircularIndicator mSelectedView;
    private int mViewSize;

    public YearPickerView(Context context, DatePickerController datePickerController) {
        super(context);
        this.mController = datePickerController;
        this.mController.registerOnDateChangedListener(this);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        Resources resources = context.getResources();
        this.mViewSize = resources.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height);
        this.mChildSize = resources.getDimensionPixelOffset(R.dimen.year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.init(context);
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new StateListDrawable());
        this.setDividerHeight(0);
        this.onDateChanged();
    }

    private static int getYearFromTextView(TextView view) {
        return Integer.valueOf(view.getText().toString());
    }

    private void init(Context context) {
        ArrayList<String> years = new ArrayList<String>();
        for (int year = this.mController.getMinYear(); year <= this.mController.getMaxYear(); ++year) {
            years.add(String.format("%d", year));
        }
        this.mAdapter = new YearAdapter(context, R.layout.year_label_text_view, years);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    @Override
    public void onDateChanged() {
        this.mAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedDay().year - this.mController.getMinYear());
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mController.tryVibrate();
        TextViewWithCircularIndicator clickedView = (TextViewWithCircularIndicator)view;
        if (clickedView != null) {
            if (clickedView != this.mSelectedView) {
                if (this.mSelectedView != null) {
                    this.mSelectedView.drawIndicator(false);
                    this.mSelectedView.requestLayout();
                }
                clickedView.drawIndicator(true);
                clickedView.requestLayout();
                this.mSelectedView = clickedView;
            }
            this.mController.onYearSelected(YearPickerView.getYearFromTextView(clickedView));
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void postSetSelectionFromTop(final int position, final int y) {
        this.post(new Runnable(){

            @Override
            public void run() {
                YearPickerView.this.setSelectionFromTop(position, y);
                YearPickerView.this.requestLayout();
            }
        });
    }

    private class YearAdapter
    extends ArrayAdapter<String> {
        public YearAdapter(Context context, int resource, List<String> years) {
            super(context, resource, years);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextViewWithCircularIndicator v = (TextViewWithCircularIndicator)super.getView(position, convertView, parent);
            v.requestLayout();
            int year = YearPickerView.getYearFromTextView(v);
            boolean selected = ((YearPickerView)YearPickerView.this).mController.getSelectedDay().year == year;
            v.drawIndicator(selected);
            if (selected) {
                YearPickerView.this.mSelectedView = v;
            }
            return v;
        }
    }
}

