/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.SeekBar;
import com.yy.mobile.ui.utils.DensityUtil;

public class TextSeekBar
extends SeekBar {
    private String str = "";
    private Paint mPaint;
    Rect rect = new Rect();
    int padding;

    public TextSeekBar(Context context) {
        super(context);
        this.initPaint();
    }

    public TextSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPaint();
    }

    public TextSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPaint();
    }

    @TargetApi(value=21)
    public TextSeekBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initPaint();
    }

    public void setText(String text) {
        this.str = text;
    }

    public void setTextColor(int color2) {
        this.mPaint.setColor(color2);
    }

    public void setTextSize(int size) {
        this.mPaint.setTextSize((float)size);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.str != null && this.str.length() > 0 && this.mPaint != null) {
            this.mPaint.getTextBounds(this.str, 0, this.str.length(), this.rect);
            int x = this.getWidth() - this.rect.width() - this.padding;
            int y = this.getHeight() / 2 - this.rect.centerY();
            canvas.drawText(this.str, (float)x, (float)y, this.mPaint);
        }
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.padding = DensityUtil.dip2px(this.getContext(), 24.0f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.performClick();
        }
        return true;
    }
}

