/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.yy.mobile.framework.R;

public class IcsLinearLayout
extends LinearLayout {
    private Drawable mDivider;
    private int mDividerWidth;
    private int mDividerHeight;
    private int mShowDividers;
    private int mDividerPadding;

    @SuppressLint(value={"NewApi"})
    public IcsLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(attrs);
    }

    public IcsLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(attrs);
    }

    public IcsLinearLayout(Context context) {
        super(context);
    }

    private void initView(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.IcsLinearLayout);
        this.setDividerDrawable(a.getDrawable(R.styleable.IcsLinearLayout_icsLinearLayout_divider));
        this.mShowDividers = a.getInt(R.styleable.IcsLinearLayout_icsLinearLayout_showDividers, 0);
        this.mDividerPadding = a.getDimensionPixelSize(R.styleable.IcsLinearLayout_icsLinearLayout_dividerPadding, 0);
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.getOrientation() == 1) {
            this.drawDividersVertical(canvas);
        } else {
            this.drawDividersHorizontal(canvas);
        }
    }

    void drawDividersVertical(Canvas canvas) {
        LinearLayout.LayoutParams lp;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int top = child.getTop() - lp.topMargin - this.mDividerHeight;
            this.drawHorizontalDivider(canvas, top);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int bottom = 0;
            if (child == null) {
                bottom = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                bottom = child.getBottom() + lp.bottomMargin;
            }
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    void drawDividersHorizontal(Canvas canvas) {
        LinearLayout.LayoutParams lp;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int position = child.getLeft() - lp.leftMargin - this.mDividerWidth;
            this.drawVerticalDivider(canvas, position);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            int position;
            View child = this.getChildAt(count - 1);
            if (child == null) {
                position = this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
            } else {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                position = child.getRight() + lp.rightMargin;
            }
            this.drawVerticalDivider(canvas, position);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (childIndex == this.getChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        if ((this.mShowDividers & 2) != 0) {
            boolean hasVisibleViewBefore = false;
            for (int i = childIndex - 1; i >= 0; --i) {
                if (this.getChildAt(i).getVisibility() == 8) continue;
                hasVisibleViewBefore = true;
                break;
            }
            return hasVisibleViewBefore;
        }
        return false;
    }

    public void setDividerDrawable(Drawable divider) {
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = divider;
        if (divider != null) {
            this.mDividerWidth = divider.getIntrinsicWidth();
            this.mDividerHeight = divider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.setWillNotDraw(divider == null);
        this.requestLayout();
    }

    public void setDividerPadding(int padding) {
        this.mDividerPadding = padding;
    }
}

