/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.yy.mobile.framework.R;
import com.yy.mobile.util.log.MLog;

public class FullScreenLinkLayout
extends RelativeLayout {
    private static final String TAG = "FullScreenLinkLayout";
    private int mMaxWidth;
    private int mMaxHeight;
    private int ml;
    private int mt;
    private int mr;
    private int mb;
    private int mHeightMeasureSpec;
    private int mWidthMeasureSpec;
    private boolean mCanFreedomResize = true;

    public FullScreenLinkLayout(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    @TargetApi(value=21)
    public FullScreenLinkLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    public FullScreenLinkLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public FullScreenLinkLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs == null) {
            return;
        }
        TypedArray attr2 = context.obtainStyledAttributes(attrs, R.styleable.MobileLiveFullScreenLinkLayout, defStyleAttr, defStyleRes);
        if (attr2 == null) {
            return;
        }
        try {
            this.mCanFreedomResize = attr2.getBoolean(R.styleable.MobileLiveFullScreenLinkLayout_layout_link_can_freedom_resize, true);
        }
        catch (Resources.NotFoundException e) {
            MLog.error((Object)TAG, "printStackTrace", e, new Object[0]);
        }
        finally {
            attr2.recycle();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mMaxWidth == 0 || h > this.mMaxHeight || w > this.mMaxWidth) {
            this.mMaxWidth = w;
            this.mMaxHeight = h;
        }
        if (this.mCanFreedomResize) {
            super.onSizeChanged(w, h, oldw, oldh);
        } else {
            super.onSizeChanged(this.mMaxWidth, this.mMaxHeight, oldw, oldh);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.ml == 0 && this.mb == 0 && this.mt == 0 && this.mr == 0 || r > this.mr || b > this.mb) {
            this.mb = b;
            this.mr = r;
            this.ml = l;
            this.mt = t;
        }
        if (this.mCanFreedomResize) {
            super.onLayout(changed, l, t, r, b);
        } else {
            super.onLayout(changed, this.ml, this.mt, this.mr, this.mb);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mWidthMeasureSpec == 0 || widthMeasureSpec > this.mWidthMeasureSpec || heightMeasureSpec > this.mHeightMeasureSpec) {
            this.mWidthMeasureSpec = widthMeasureSpec;
            this.mHeightMeasureSpec = heightMeasureSpec;
        }
        if (this.mCanFreedomResize) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            super.onMeasure(this.mWidthMeasureSpec, this.mHeightMeasureSpec);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mMaxWidth = 0;
        this.mMaxHeight = 0;
        this.ml = 0;
        this.mt = 0;
        this.mr = 0;
        this.mb = 0;
        this.mHeightMeasureSpec = 0;
        this.mWidthMeasureSpec = 0;
    }

    public void setCanFreedomResize(boolean canFreedomResize) {
        this.mCanFreedomResize = canFreedomResize;
    }

    public boolean getCanFreedomResize() {
        return this.mCanFreedomResize;
    }
}

