/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.EditText;
import com.yy.mobile.framework.R;

public class EasyClearEditText
extends EditText {
    private static final String TAG = "EasyClearEditText";
    private boolean isAttached = false;
    private boolean allowInteractive = true;
    private boolean isSmartIconShow = false;
    private Drawable smartIcon = null;
    private int smartIconTag = -1;
    private OnSmartIconClickListener smartIconClickListener;
    private TextWatcher textWatcher;
    private boolean isSelectAll = false;

    public EasyClearEditText(Context context) {
        super(context);
        this.init(null);
    }

    public EasyClearEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public EasyClearEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    public boolean isSelectAll() {
        return this.isSelectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.isSelectAll = selectAll;
    }

    public OnSmartIconClickListener getSmartIconClickListener() {
        return this.smartIconClickListener;
    }

    public void setSmartIconClickListener(OnSmartIconClickListener smartIconClickListener) {
        this.smartIconClickListener = smartIconClickListener;
    }

    public boolean isAllowInteractive() {
        return this.allowInteractive;
    }

    public void setAllowInteractive(boolean allowInteractive) {
        this.allowInteractive = allowInteractive;
    }

    public int getSmartIconTag() {
        return this.smartIconTag;
    }

    public void setSmartIconTag(int smartIconTag) {
        this.smartIconTag = smartIconTag;
    }

    public Drawable getSmartIcon() {
        return this.smartIcon;
    }

    public void setSmartIcon(int id2) {
        this.smartIcon = this.getResources().getDrawable(id2);
    }

    public void setSmartIcon(Drawable smartIcon) {
        this.smartIcon = smartIcon;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isAttached) {
            this.isAttached = true;
            this.addTextChangedListener(this.textWatcher);
            this.handleSmartIconVisibility(this.getEditableText().length());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.isAttached) {
            this.isAttached = false;
            this.removeTextChangedListener(this.textWatcher);
        }
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        if (this.isSmartIconShow && right == null) {
            this.isSmartIconShow = false;
        }
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        if (this.isSmartIconShow && right == 0) {
            this.isSmartIconShow = false;
        }
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.allowInteractive && this.isSmartIconShow && event.getAction() == 1) {
            Drawable[] drawables = this.getCompoundDrawables();
            if (drawables != null && drawables.length == 4) {
                int width;
                Drawable dr = drawables[2];
                int n = width = dr == null ? 0 : dr.getBounds().width();
                if (event.getX() >= (float)(this.getRight() - width - this.getPaddingRight() * 2) && this.smartIconClickListener != null) {
                    this.smartIconClickListener.onClick(this.smartIconTag, this);
                }
            }
        } else if (this.isSelectAll && this.smartIconClickListener != null && event.getAction() == 1) {
            this.smartIconClickListener.onClick(this.smartIconTag, this);
        }
        return super.onTouchEvent(event);
    }

    private void init(AttributeSet attrs) {
        this.createTextWatcher();
        this.handleAttrs(attrs);
    }

    private void handleAttrs(AttributeSet attrs) {
        if (!this.isInEditMode()) {
            int resouceId = -1;
            TypedArray typeArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.EasyClearEditText);
            int attrsCount = typeArray.getIndexCount();
            for (int i = 0; i < attrsCount; ++i) {
                int attr2 = typeArray.getIndex(i);
                if (attr2 == R.styleable.EasyClearEditText_allowInteractive) {
                    this.allowInteractive = typeArray.getBoolean(R.styleable.EasyClearEditText_allowInteractive, true);
                    continue;
                }
                if (attr2 == R.styleable.EasyClearEditText_tipsIcon) {
                    resouceId = typeArray.getResourceId(R.styleable.EasyClearEditText_tipsIcon, 0);
                    this.smartIcon = resouceId > 0 ? typeArray.getResources().getDrawable(resouceId) : null;
                    continue;
                }
                if (attr2 != R.styleable.EasyClearEditText_tag) continue;
                resouceId = typeArray.getResourceId(R.styleable.EasyClearEditText_tag, 0);
                this.smartIconTag = resouceId > 0 ? typeArray.getResources().getInteger(resouceId) : typeArray.getInt(R.styleable.EasyClearEditText_tag, -1);
            }
            typeArray.recycle();
        }
    }

    private void createTextWatcher() {
        if (!this.isInEditMode()) {
            this.textWatcher = new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void afterTextChanged(Editable s) {
                    EasyClearEditText.this.handleSmartIconVisibility(s.length());
                }
            };
        }
    }

    private void handleSmartIconVisibility(int editableLength) {
        if (editableLength > 0 && !this.isSmartIconShow) {
            this.showSmartIcon();
        } else if (editableLength == 0) {
            this.hideSmartIcon();
        }
    }

    private void showSmartIcon() {
        if (this.smartIcon != null) {
            this.isSmartIconShow = true;
            Drawable[] drawables = this.getCompoundDrawables();
            if (drawables != null && drawables.length == 4) {
                this.setCompoundDrawablesWithIntrinsicBounds(drawables[0], drawables[1], this.smartIcon, drawables[3]);
            } else {
                this.setCompoundDrawablesWithIntrinsicBounds(null, null, this.smartIcon, null);
            }
        }
    }

    private void hideSmartIcon() {
        Drawable[] drawables = this.getCompoundDrawables();
        if (drawables != null && drawables.length == 4) {
            this.setCompoundDrawablesWithIntrinsicBounds(drawables[0], drawables[1], null, drawables[3]);
        } else {
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        }
    }

    public static OnSmartIconClickListener getDefaultSmartIconClickListener() {
        return new OnSmartIconClickListener(){

            @Override
            public void onClick(int tag, EasyClearEditText set) {
                set.setText("");
            }
        };
    }

    public static interface OnSmartIconClickListener {
        public void onClick(int var1, EasyClearEditText var2);
    }
}

