/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ScrollView;
import com.yy.mobile.ui.utils.DensityUtil;

public class CustomScrollView
extends ScrollView {
    private static final String TAG = "CustomScrollView";
    private static final int BACK_HEIGHT_VIEW = 240;
    private int lastScrollY;
    private ChannelInfoOnlistener mChannelInfoOnlistener;

    public CustomScrollView(Context context) {
        this(context, null);
    }

    public CustomScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mChannelInfoOnlistener != null) {
            if (t >= DensityUtil.dip2px(this.getContext(), 240.0f)) {
                this.mChannelInfoOnlistener.onChannelInfoBackOnlistener(true);
            } else {
                this.mChannelInfoOnlistener.onChannelInfoBackOnlistener(false);
            }
        }
        if (this.mChannelInfoOnlistener != null) {
            this.lastScrollY = this.getScrollY();
            this.mChannelInfoOnlistener.onScroll(this.lastScrollY);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return super.onTouchEvent(ev);
    }

    public void setChannelInfoOnlistener(ChannelInfoOnlistener channelInfoOnlistener) {
        this.mChannelInfoOnlistener = channelInfoOnlistener;
    }

    public static interface ChannelInfoOnlistener {
        public void onChannelInfoBackOnlistener(boolean var1);

        public void onScroll(int var1);
    }
}

