/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import com.yy.mobile.mvp.MvpFragment;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.mvp.MvpView;
import java.lang.ref.WeakReference;

public class BaseFragment<P extends MvpPresenter<V>, V extends MvpView>
extends MvpFragment<P, V> {
    private static WeakReference<ILifeCycleListener> sLifeCycleListener;
    private boolean mPaused = false;
    private boolean mHiddened = false;
    private boolean mSelected = true;

    @Override
    public void onResume() {
        ILifeCycleListener listener;
        this.mPaused = false;
        super.onResume();
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onResumed(this);
        }
    }

    @Override
    public void onPause() {
        ILifeCycleListener listener;
        super.onPause();
        this.mPaused = true;
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onPaused(this);
        }
    }

    @Override
    public void onStop() {
        ILifeCycleListener listener;
        super.onStop();
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onStoped(this);
        }
    }

    @Override
    public void onDestroy() {
        ILifeCycleListener listener;
        super.onDestroy();
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onDestroyed(this);
        }
    }

    public static void setLifeCycleListener(ILifeCycleListener listener) {
        sLifeCycleListener = listener == null ? null : new WeakReference<ILifeCycleListener>(listener);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.handleStatusBar(view);
    }

    public static ILifeCycleListener getLifeCycleListener() {
        return sLifeCycleListener != null ? (ILifeCycleListener)sLifeCycleListener.get() : null;
    }

    public void onAttach(Context context) {
        ILifeCycleListener listener;
        super.onAttach(context);
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onAttached(this);
        }
    }

    public void onAttach(Activity activity) {
        ILifeCycleListener listener;
        super.onAttach(activity);
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onAttached(this);
        }
    }

    public void onDetach() {
        ILifeCycleListener listener;
        super.onDetach();
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onDetached(this);
        }
    }

    public void onHiddenChanged(boolean hidden) {
        ILifeCycleListener listener;
        this.mHiddened = hidden;
        super.onHiddenChanged(hidden);
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onHiddenChanged(this, hidden);
        }
    }

    public void onSelected() {
        ILifeCycleListener listener;
        this.mSelected = true;
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onSelectChanged(this, true);
        }
    }

    public void onUnSelected() {
        ILifeCycleListener listener;
        this.mSelected = false;
        if (sLifeCycleListener != null && (listener = (ILifeCycleListener)sLifeCycleListener.get()) != null) {
            listener.onSelectChanged(this, false);
        }
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public boolean isHiddened() {
        return this.mHiddened;
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    protected boolean handleStatusBar(View container) {
        return false;
    }

    public static interface ILifeCycleListener {
        public void onResumed(BaseFragment var1);

        public void onPaused(BaseFragment var1);

        public void onStoped(BaseFragment var1);

        public void onDestroyed(BaseFragment var1);

        public void onAttached(BaseFragment var1);

        public void onDetached(BaseFragment var1);

        public void onHiddenChanged(BaseFragment var1, boolean var2);

        public void onSelectChanged(BaseFragment var1, boolean var2);
    }
}

