/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.framework.R;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;

public class AutoSpaceLayout
extends ViewGroup {
    private static final String TAG = "AutoSpaceLayout";
    private int mGravity = 3;
    ArrayList<View> visibles = new ArrayList();

    public AutoSpaceLayout(Context context) {
        this(context, null);
    }

    public AutoSpaceLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AutoSpaceLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoSpaceLayout);
            this.mGravity = a.getInt(R.styleable.AutoSpaceLayout_gravity, 3);
            a.recycle();
        }
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int cCount = this.getChildCount();
        int childWidthMeasureSpec = 0;
        for (int i = 0; i < cCount; ++i) {
            View child = this.getChildAt(i);
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            childWidthMeasureSpec = lp.width <= 0 ? View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)lp.width), (int)0x40000000);
            child.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)0x40000000));
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.getWidth();
        int count = this.getChildCount();
        int childWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            childWidth += child.getMeasuredWidth();
        }
        int perSpace = (width - childWidth) / (count - 1);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "count=%d,childWidth=%d,width=%d,perSpace=%d", count, childWidth, width, perSpace);
        }
        this.visibles.clear();
        for (int j = 0; j < count; ++j) {
            View child = this.getChildAt(j);
            if (child.getVisibility() == 8) continue;
            this.visibles.add(child);
        }
        int childLeft = 0;
        int childWidthSum = 0;
        for (View view : this.visibles) {
            childWidthSum += view.getMeasuredWidth() + perSpace;
        }
        childWidthSum -= perSpace;
        switch (this.mGravity) {
            case 3: {
                childLeft = 0;
                break;
            }
            case 17: {
                childLeft = (width - childWidthSum) / 2;
                break;
            }
            case 5: {
                childLeft = width - childWidthSum;
                break;
            }
        }
        for (View visibleChild : this.visibles) {
            int childW = visibleChild.getMeasuredWidth();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "childW=%d,childLeft=%d", childW, childLeft);
            }
            visibleChild.layout(childLeft, 0, childLeft + childW, this.getHeight());
            childLeft += childW + perSpace;
        }
    }
}

