/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext.wrap;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.widget.TextView;
import com.yy.mobile.richtext.RichTextManager;
import com.yy.mobile.richtext.media.ImageFilter;
import java.util.regex.Matcher;

public class RichTextWrapper {
    private static final String TAG = "RichTextWrapper";
    private TextView textView;
    private int mMaxWidth = Integer.MAX_VALUE;
    private Object tag;

    public RichTextWrapper(TextView textView) {
        this(textView, true);
    }

    public RichTextWrapper(TextView textView, boolean movement) {
        this.textView = textView;
        if (movement) {
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }
        this.init();
    }

    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public TextView getTextView() {
        return this.textView;
    }

    public void setText(CharSequence text) {
        this.setText(text, null);
    }

    public void setText(CharSequence text, Object tag) {
        this.tag = tag;
        String message = text.toString();
        StringBuilder sb = new StringBuilder();
        if (ImageFilter.isImageMessage(message)) {
            sb.reverse();
            Matcher matcher = ImageFilter.getImageMatcher(message);
            if (matcher.find()) {
                String cs1 = message.substring(0, matcher.end());
                String cs2 = message.substring(matcher.end(), message.length());
                if (TextUtils.isEmpty((CharSequence)cs2)) {
                    sb.append(cs1);
                } else {
                    sb.append(cs1).append("\n").append(cs2);
                }
            }
        } else {
            sb.append(message);
        }
        this.textView.setText((CharSequence)sb.toString());
    }

    public void setText(CharSequence text, Object tag, boolean isParseBrower) {
        this.tag = tag;
        this.textView.setText(text);
    }

    private void init() {
        this.textView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                RichTextManager.getInstance().filterAll(RichTextWrapper.this.textView.getContext(), (CharSequence)s, RichTextWrapper.this.mMaxWidth, RichTextWrapper.this.tag);
            }
        });
    }

    public void setVisibility(int visibility) {
        this.textView.setVisibility(visibility);
    }
}

