/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext.media;

import android.text.TextUtils;
import android.util.Pair;
import com.yy.mobile.richtext.BaseRichTextFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MediaFilter
extends BaseRichTextFilter {
    public static final int LOADING_STATE = 0;
    public static final int NORMAL_STATE = 101;
    public static final int FAILED_STATE = -1;
    protected static final int COMPLETE_OPAQUE = 255;
    protected static final int LIGHT_TRANSPARENT = 40;
    protected static final String REG_CONTENT = "[^\\[\\]]+";
    protected static final String INDEX = ";state=";
    protected static final String PROGRESS_FORMAT = ";state=%d";
    public static final String REG_URL = "\\(?(http://|https://|www[.])[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|.]";
    public static final Pattern UrlPattern = Pattern.compile("\\(?(http://|https://|www[.])[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|.]", 2);

    protected static Pattern createPattern(String begin, String end) {
        String reg = MediaFilter.convertReg(begin) + REG_CONTENT + MediaFilter.convertReg(end);
        return Pattern.compile(reg);
    }

    protected static String convertReg(String tag) {
        return tag.replace("[", "\\[").replace("]", "\\]");
    }

    protected static String createMessage(String begin, String end, String message) {
        return begin + message + end;
    }

    protected static String createMessage(String begin, String end, String message, int progress) {
        return begin + message + String.format(PROGRESS_FORMAT, progress) + end;
    }

    protected static String getMessageContent(String message, int start, int end, String beginTag, String endTag) {
        return message.substring(start + beginTag.length(), end - endTag.length());
    }

    protected static Pair<String, Integer> parseMessage(String message, int start, int end, String beginTag, String endTag) {
        String[] strs;
        int progress = 101;
        String content = MediaFilter.getMessageContent(message, start, end, beginTag, endTag);
        for (String string : strs = content.split(INDEX)) {
        }
        if (strs.length > 1) {
            progress = Integer.parseInt(strs[1]);
        }
        return new Pair((Object)strs[0], (Object)progress);
    }

    protected static List<MediaInfo> parseMediaInfo(String message, Matcher matcher, String begin, String end) {
        ArrayList<MediaInfo> infos = new ArrayList<MediaInfo>();
        int index = 0;
        while (matcher.find()) {
            Pair<String, Integer> pair = MediaFilter.parseMessage(message, matcher.start(), matcher.end(), begin, end);
            MediaInfo mediaInfo = new MediaInfo(matcher.start(), matcher.end(), (String)pair.first, (Integer)pair.second, null, index);
            ++index;
            infos.add(mediaInfo);
        }
        return infos;
    }

    public static boolean isUrl(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        String reg = "^\\(?(http://|https://|www[.])[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|.]$";
        return Pattern.matches(reg, content);
    }

    public static class MediaInfo
    implements Serializable {
        public int progress;
        public int start;
        public int end;
        public String content;
        public Object tag;
        public int index;

        public MediaInfo(int start, int end, String content, int state) {
            this.start = start;
            this.end = end;
            this.content = content;
            this.progress = state;
        }

        public MediaInfo(int start, int end, String content, int state, Object tag) {
            this.start = start;
            this.end = end;
            this.content = content;
            this.progress = state;
            this.tag = tag;
        }

        public MediaInfo(int start, int end, String content, int state, Object tag, int index) {
            this.start = start;
            this.end = end;
            this.content = content;
            this.progress = state;
            this.tag = tag;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MediaInfo mediaInfo = (MediaInfo)o;
            if (this.tag == null || mediaInfo.tag == null || !this.tag.equals(mediaInfo.tag)) {
                return false;
            }
            if (!this.content.equals(mediaInfo.content)) {
                return false;
            }
            return this.index == mediaInfo.index;
        }

        public int hashCode() {
            return this.content.hashCode();
        }
    }
}

