/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext.media;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.style.DynamicDrawableSpan;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.richtext.media.MediaFilter;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImVoiceFilter
extends MediaFilter {
    private static final String VOICE_BEGIN = "[dyimg][dysnd]";
    private static final String VOICE_END = "[/dysnd][/dyimg]";
    private static final Pattern VOICE_PATTERN = ImVoiceFilter.createPattern("[dyimg][dysnd]", "[/dysnd][/dyimg]");
    private static final Pattern TIME_PATTERN = Pattern.compile("\\d{2}:\\d{2}");

    public static ImVoiceInfo parseImVoiceRawMsg(String msg) {
        ImVoiceInfo info = null;
        if (!ImVoiceFilter.isImVoiceMessage(msg)) {
            return info;
        }
        Matcher matcher = VOICE_PATTERN.matcher(msg);
        while (matcher.find()) {
            info = new ImVoiceInfo();
            info.rawText = msg;
            info.timeInS = ImVoiceFilter.parseTimeStr(msg.substring(0, matcher.start()));
            info.content = msg.substring(matcher.start() + VOICE_BEGIN.length(), matcher.end() - VOICE_END.length());
            info.suffixStr = msg.substring(matcher.end());
        }
        return info;
    }

    public static int parseTimeStr(String str) {
        if (FP.empty(str)) {
            return 0;
        }
        if (!TIME_PATTERN.matcher(str).find()) {
            return 0;
        }
        try {
            int minute = Integer.parseInt(str.split(":")[0]);
            int second = Integer.parseInt(str.split(":")[1]);
            int allSec = minute * 60 + second;
            return allSec;
        }
        catch (Exception e) {
            MLog.error((Object)"parseTimeStr", "parseTimeStr e = " + e, new Object[0]);
            return 0;
        }
    }

    public static String createVoiceMsg(ImVoiceInfo info) {
        if (info == null) {
            return null;
        }
        return info.getTimeLengthStr() + VOICE_BEGIN + info.content + VOICE_END + info.suffixStr;
    }

    public static boolean isImVoiceMessage(String message) {
        if (FP.empty(message)) {
            return false;
        }
        return VOICE_PATTERN.matcher(message).find();
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
    }

    public void requestVoiceCache(ImVoiceInfo info, Context context, Spannable spannable, File file) {
        RequestManager.instance().submitDownloadRequest(info.content, file.getPath(), new ResponseListener<String>(){

            @Override
            public void onResponse(String response) {
            }
        }, new ResponseErrorListener(){

            @Override
            public void onErrorResponse(RequestError error) {
            }
        }, new ProgressListener(){

            @Override
            public void onProgress(ProgressInfo info) {
            }
        }, true, false);
    }

    class ImVoiceSpan
    extends DynamicDrawableSpan {
        private String content;
        private Drawable drawable;

        public ImVoiceSpan(Drawable drawable2, String content) {
            this.drawable = drawable2;
            this.content = content;
        }

        public Drawable getDrawable() {
            return this.drawable;
        }

        public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
            super.draw(canvas, text, start, end, x, top, y, bottom, paint);
            canvas.save();
            Paint.FontMetricsInt fm = paint.getFontMetricsInt();
            float textHeight = (float)Math.ceil(fm.descent - fm.ascent);
            float transX = x + 10.0f;
            float transY = y / 2 + 20;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug("hjinw", "top = " + top + ";y = " + y + ";bottom = " + bottom + ";height = " + textHeight, new Object[0]);
            }
            canvas.translate(transX, transY);
            canvas.drawText(this.content, 0.0f, 0.0f, paint);
            canvas.restore();
        }
    }

    public static class ImVoiceInfo {
        public int timeInS;
        public String content;
        public String suffixStr;
        public String rawText;

        ImVoiceInfo() {
        }

        public ImVoiceInfo(int timeLength, String content, String suffixStr, String rawText) {
            this.timeInS = timeLength;
            this.content = content;
            this.suffixStr = suffixStr;
            this.rawText = rawText;
        }

        public boolean isHttpFormat() {
            if (FP.empty(this.content)) {
                return false;
            }
            return MediaFilter.isUrl(this.content);
        }

        public String getTimeLengthStr() {
            String timeStr = this.timeInS < 10 ? "00:0" + String.valueOf(this.timeInS) : (this.timeInS <= 60 ? "00:" + String.valueOf(this.timeInS) : "00:60");
            return timeStr;
        }
    }
}

