/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext.media;

import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.DiskCache;
import com.yy.mobile.util.log.MLog;
import java.io.File;

public class ImCacheSetting {
    private static final String TAG = "ImCacheSetting";
    protected Cache mCache;
    protected File mVoiceCacheDirFile;
    protected static ImCacheSetting mInstance;

    protected ImCacheSetting() {
    }

    public static synchronized ImCacheSetting instance() {
        if (mInstance == null) {
            mInstance = new ImCacheSetting();
        }
        return mInstance;
    }

    public void init(String imageCacheDir, String voiceCacheDir) {
        File cacheDirFile = DiskCache.getCacheDir(BasicConfig.getInstance().getAppContext(), imageCacheDir);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose(TAG, "Init Image Filter, cache = %s", cacheDirFile);
        }
        this.mCache = new DiskCache(cacheDirFile, Integer.MAX_VALUE, 1.0f);
        this.mCache.initialize();
        this.mVoiceCacheDirFile = DiskCache.getCacheDir(BasicConfig.getInstance().getAppContext(), voiceCacheDir);
    }

    public Cache getImageCache() {
        return this.mCache;
    }

    public File getVoiceCacheDirFile() {
        if (this.mVoiceCacheDirFile == null) {
            MLog.error((Object)TAG, "create voice cache dir failed", new Object[0]);
            return null;
        }
        if (!this.mVoiceCacheDirFile.exists() && !this.mVoiceCacheDirFile.mkdirs()) {
            MLog.error((Object)TAG, "create voice cache dir failed", new Object[0]);
            return null;
        }
        return this.mVoiceCacheDirFile;
    }
}

