/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.text.Spannable;
import com.yy.mobile.richtext.AirTicketFilter;
import com.yy.mobile.richtext.ChannelAirTicketParser;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChannelTicketFilter
extends AirTicketFilter {
    public static final String TAG = "ChannelTicketFilter";
    private static final String NUMBER_REG = "[0-9]+";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");

    public ChannelTicketFilter(int id2) {
        super(id2);
    }

    public static List<ChannelTicketInfo> parseChannelTicket(String msg) {
        ArrayList<ChannelTicketInfo> infoList = new ArrayList<ChannelTicketInfo>();
        CharSequence complateFormatMsg = ChannelAirTicketParser.parseCompleteFormatMsg(msg);
        Matcher matcher = ChannelAirTicketParser.AIR_TICKET_PATTERN.matcher(complateFormatMsg);
        while (matcher.find()) {
            String channelMsg = complateFormatMsg.toString().substring(matcher.start(), matcher.end());
            Matcher m = NUMBER_PATTERN.matcher(channelMsg);
            long sid = 0L;
            long subSid = 0L;
            try {
                if (m.find()) {
                    sid = Long.parseLong(channelMsg.substring(m.start(), m.end()));
                }
                if (channelMsg.contains("subid=") && m.find()) {
                    subSid = Long.parseLong(channelMsg.substring(m.start(), m.end()));
                }
            }
            catch (NumberFormatException e) {
                MLog.error((Object)"hjinw", "parse Channel sid or subSid error :%s", e, new Object[0]);
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug("hjinw", "sid = %d, subSid = %d", sid, subSid);
            }
            infoList.add(new ChannelTicketInfo(matcher.start(), matcher.end(), sid, subSid));
        }
        return infoList;
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        if (!ChannelTicketFilter.isChannelTicketMessage((CharSequence)spannable)) {
            return;
        }
        if (this.ticketDrawable == null) {
            this.ticketDrawable = this.getTicketDrawable(context);
        }
        if (this.ticketDrawable != null) {
            this.setSpannable(spannable);
        } else {
            MLog.info(TAG, "ticketDrawable:null", new Object[0]);
        }
    }

    private void setSpannable(Spannable spannable) {
        List<ChannelTicketInfo> infos = ChannelTicketFilter.parseChannelTicket(spannable.toString());
        for (ChannelTicketInfo info : infos) {
            AirTicketFilter.AirTicketSpan airTicketSpan = new AirTicketFilter.AirTicketSpan(this.ticketDrawable, String.valueOf(info.sid));
            ChannelTicketClickSpan clickSpan = new ChannelTicketClickSpan(info.sid, info.subSid);
            this.setSpannable(FP.toList(new Object[]{airTicketSpan, clickSpan}), spannable, info.start, info.end, 33);
        }
    }

    public static boolean isChannelTicketMessage(CharSequence msg) {
        return ChannelAirTicketParser.isChannelTicketMessage(msg);
    }

    public static String replaceChannelTicketWithGivenStr(String message, String givenStr) {
        CharSequence complateFormatMsg = ChannelAirTicketParser.parseCompleteFormatMsg(message);
        Matcher m = ChannelAirTicketParser.AIR_TICKET_PATTERN.matcher(complateFormatMsg);
        return m.replaceAll(givenStr).trim();
    }

    public static class ChannelTicketInfo {
        public int start;
        public int end;
        public long sid;
        public long subSid;

        public ChannelTicketInfo(int start, int end, long sid, long subSid) {
            this.start = start;
            this.end = end;
            this.sid = sid;
            this.subSid = subSid;
        }

        public String toString() {
            return "[start = " + this.start + "; end = " + this.end + "; sid = " + this.sid + "; subSid = " + this.subSid + "]";
        }
    }

    public class ChannelTicketClickSpan
    extends AirTicketFilter.TicketClickSpan {
        final long channelSid;
        final long channelSubSid;

        public ChannelTicketClickSpan(long sid, long subSid) {
            this.channelSid = sid;
            this.channelSubSid = subSid;
        }

        public long getChannelSid() {
            return this.channelSid;
        }

        public long getChannelSubSid() {
            return this.channelSubSid;
        }
    }
}

