/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.mvplifecycle2;

import android.os.Bundle;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.trello.rxlifecycle2.OutsideLifecycleException;
import com.trello.rxlifecycle2.RxLifecycle;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.mvplifecycle2.MvpPresenterEvent;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.subjects.BehaviorSubject;
import javax.annotation.Nonnull;

public class RxMvpPresenter<V extends MvpView>
extends MvpPresenter<V>
implements LifecycleProvider<MvpPresenterEvent> {
    private static final Function<MvpPresenterEvent, MvpPresenterEvent> PRESENTER_LIFECYCLE = new Function<MvpPresenterEvent, MvpPresenterEvent>(){

        public MvpPresenterEvent apply(MvpPresenterEvent lastEvent) throws Exception {
            switch (lastEvent) {
                case ATTACH: {
                    return MvpPresenterEvent.DETACH;
                }
                case CREATE: {
                    return MvpPresenterEvent.DESTROY;
                }
                case START: {
                    return MvpPresenterEvent.STOP;
                }
                case RESUME: {
                    return MvpPresenterEvent.PAUSE;
                }
                case PAUSE: {
                    return MvpPresenterEvent.STOP;
                }
                case STOP: {
                    return MvpPresenterEvent.DESTROY;
                }
                case DESTROY: {
                    return MvpPresenterEvent.DETACH;
                }
                case DETACH: {
                    throw new OutsideLifecycleException("Cannot bind to Fragment lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + (Object)((Object)lastEvent) + " not yet implemented");
        }
    };
    private final BehaviorSubject<MvpPresenterEvent> lifecycleSubject = BehaviorSubject.create();

    @Nonnull
    public Observable<MvpPresenterEvent> lifecycle() {
        return this.lifecycleSubject.hide();
    }

    @Nonnull
    public <T> LifecycleTransformer<T> bindUntilEvent(@Nonnull MvpPresenterEvent event) {
        return RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)((Object)event));
    }

    @Nonnull
    public <T> LifecycleTransformer<T> bindToLifecycle() {
        return RxLifecycle.bind(this.lifecycleSubject, PRESENTER_LIFECYCLE);
    }

    @Override
    protected void attachView(V view) {
        super.attachView(view);
        this.lifecycleSubject.onNext((Object)MvpPresenterEvent.ATTACH);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.lifecycleSubject.onNext((Object)MvpPresenterEvent.CREATE);
    }

    @Override
    protected void onDestroy() {
        this.lifecycleSubject.onNext((Object)MvpPresenterEvent.DESTROY);
        super.onDestroy();
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.lifecycleSubject.onNext((Object)MvpPresenterEvent.START);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.lifecycleSubject.onNext((Object)MvpPresenterEvent.RESUME);
    }

    @Override
    protected void onPause() {
        this.lifecycleSubject.onNext((Object)MvpPresenterEvent.PAUSE);
        super.onPause();
    }

    @Override
    protected void onStop() {
        this.lifecycleSubject.onNext((Object)MvpPresenterEvent.STOP);
        super.onStop();
    }

    @Override
    protected void detachView() {
        super.detachView();
        this.lifecycleSubject.onNext((Object)MvpPresenterEvent.DETACH);
    }
}

