/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.imageloader;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.util.DimenConverter;

public class RoundImageView
extends RecycleImageView {
    private static final int DEFAULT_ROUND_CONER_RADIUS = 4;
    private int roundWidth = 4;
    private Paint roundPaint;
    private Paint imagePaint;

    public RoundImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    public RoundImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RoundImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        this.roundWidth = DimenConverter.dip2px(this.getContext(), 4.0f);
        this.roundPaint = new Paint();
        this.roundPaint.setColor(-1);
        this.roundPaint.setAntiAlias(true);
        this.roundPaint.setStyle(Paint.Style.FILL);
        this.roundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.imagePaint = new Paint();
        this.imagePaint.setXfermode(null);
    }

    public void setRoundConerRadius(int conerRadius) {
        this.roundWidth = conerRadius;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public void draw(Canvas canvas) {
        canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), this.imagePaint, 31);
        super.draw(canvas);
        this.drawTopLeft(canvas);
        this.drawTopRight(canvas);
        this.drawBottomLeft(canvas);
        this.drawBottomRight(canvas);
        canvas.restore();
    }

    private void drawTopLeft(Canvas canvas) {
        if (this.roundWidth > 0) {
            Path path = new Path();
            path.moveTo(0.0f, (float)this.roundWidth);
            path.lineTo(0.0f, 0.0f);
            path.lineTo((float)this.roundWidth, 0.0f);
            path.arcTo(new RectF(0.0f, 0.0f, (float)(this.roundWidth * 2), (float)(this.roundWidth * 2)), -90.0f, -90.0f);
            path.close();
            canvas.drawPath(path, this.roundPaint);
        }
    }

    private void drawTopRight(Canvas canvas) {
        if (this.roundWidth > 0) {
            int width = this.getWidth();
            Path path = new Path();
            path.moveTo((float)(width - this.roundWidth), 0.0f);
            path.lineTo((float)width, 0.0f);
            path.lineTo((float)width, (float)this.roundWidth);
            path.arcTo(new RectF((float)(width - 2 * this.roundWidth), 0.0f, (float)width, (float)(this.roundWidth * 2)), 0.0f, -90.0f);
            path.close();
            canvas.drawPath(path, this.roundPaint);
        }
    }

    private void drawBottomLeft(Canvas canvas) {
        if (this.roundWidth > 0) {
            int height = this.getHeight();
            Path path = new Path();
            path.moveTo(0.0f, (float)(height - this.roundWidth));
            path.lineTo(0.0f, (float)height);
            path.lineTo((float)this.roundWidth, (float)height);
            path.arcTo(new RectF(0.0f, (float)(height - 2 * this.roundWidth), (float)(this.roundWidth * 2), (float)height), 90.0f, 90.0f);
            path.close();
            canvas.drawPath(path, this.roundPaint);
        }
    }

    private void drawBottomRight(Canvas canvas) {
        if (this.roundWidth > 0) {
            int height = this.getHeight();
            int width = this.getWidth();
            Path path = new Path();
            path.moveTo((float)(width - this.roundWidth), (float)height);
            path.lineTo((float)width, (float)height);
            path.lineTo((float)width, (float)(height - this.roundWidth));
            path.arcTo(new RectF((float)(width - 2 * this.roundWidth), (float)(height - 2 * this.roundWidth), (float)width, (float)height), 0.0f, 90.0f);
            path.close();
            canvas.drawPath(path, this.roundPaint);
        }
    }
}

