/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.support.v4.util.LruCache;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.image.RecycleBitmapDrawable;
import com.yy.mobile.util.log.MLog;

public class ImageCache {
    private static final String LOG_TAG = ImageCache.class.getName();
    private LruCache<String, BitmapDrawable> mMemoryCache;
    private int memCacheSize;

    public ImageCache(Context context, AjaxImageCacheOption imageCacheOption) {
        this.memCacheSize = imageCacheOption.memCacheSize;
        this.init();
    }

    public ImageCache(Context context) {
        this(context, new AjaxImageCacheOption());
    }

    public ImageCache(Context context, int cacheSize) {
        this(context, new AjaxImageCacheOption());
    }

    private void init() {
        if (HttpLog.isDebug()) {
            HttpLog.d("Image memory cache size = " + this.memCacheSize, new Object[0]);
        }
        this.mMemoryCache = new LruCache<String, BitmapDrawable>(this.memCacheSize){

            protected void entryRemoved(boolean evicted, String key, BitmapDrawable oldValue, BitmapDrawable newValue) {
                if (oldValue instanceof RecycleBitmapDrawable) {
                    ((RecycleBitmapDrawable)oldValue).setIsCached(false);
                }
            }

            protected int sizeOf(String key, BitmapDrawable value) {
                int bitmapSize = ImageCache.getBitmapSize(value) / 1024;
                return bitmapSize == 0 ? 1 : bitmapSize;
            }
        };
    }

    public void addBitmapToCache(String data, BitmapDrawable value) {
        if (data == null || value == null) {
            return;
        }
        if (this.mMemoryCache != null) {
            if (value instanceof RecycleBitmapDrawable) {
                ((RecycleBitmapDrawable)value).setIsCached(true);
            }
            this.mMemoryCache.put((Object)data, (Object)value);
        }
    }

    public void removeBitmapFromCache(String data) {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.remove((Object)data);
        }
    }

    public BitmapDrawable getBitmapFromMemCache(String data) {
        BitmapDrawable memValue = null;
        if (this.mMemoryCache != null) {
            memValue = (BitmapDrawable)this.mMemoryCache.get((Object)data);
        }
        return memValue;
    }

    public void cleanMemCache() {
        try {
            this.mMemoryCache.evictAll();
        }
        catch (IllegalStateException e) {
            MLog.info("ImageCache", "error:" + this.mMemoryCache.size(), new Object[0]);
        }
    }

    public void cleanHalfMemCache() {
        try {
            if (this.mMemoryCache.size() > 12288) {
                this.mMemoryCache.trimToSize(this.mMemoryCache.size() / 2);
            } else {
                this.mMemoryCache.trimToSize(this.mMemoryCache.size() / 3);
            }
        }
        catch (IllegalStateException e) {
            MLog.info("ImageCache", "error:" + this.mMemoryCache.size(), new Object[0]);
        }
    }

    public static int getBitmapSize(BitmapDrawable value) {
        Bitmap bitmap = value.getBitmap();
        if (bitmap == null) {
            return 0;
        }
        return bitmap.getByteCount();
    }

    private static boolean canUseForInBitmap(Bitmap candidate, BitmapFactory.Options targetOptions) {
        int width = targetOptions.outWidth / targetOptions.inSampleSize;
        int height = targetOptions.outHeight / targetOptions.inSampleSize;
        return candidate.getWidth() == width && candidate.getHeight() == height;
    }

    public static class AjaxImageCacheOption {
        public static final boolean DEFAULT_MEM_CACHE_ENABLED = true;
        public static final int DEFAULT_MEM_CACHE_SIZE = 5120;
        public static final int DEFAULT_MAX_MEM_CACHE_SIZE = Runtime.getRuntime().maxMemory() / 0x100000L >= 256L ? 15360 : 10240;
        private int memCacheSize = 5120;
        private boolean memoryCacheEnabled = true;
        private int maxMemCacheSize = DEFAULT_MAX_MEM_CACHE_SIZE;

        public AjaxImageCacheOption() {
            this.setMemCacheSizePercent(0.1f);
        }

        public void setMemoryCacheEnabled(boolean memoryCacheEnabled) {
            this.memoryCacheEnabled = memoryCacheEnabled;
        }

        public void setMaxMemorySize(int size) {
            this.maxMemCacheSize = size;
        }

        public void setMemCacheSizePercent(float percent) {
            if (percent < 0.05f || percent > 0.8f) {
                throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.05 and 0.8 (inclusive)");
            }
            this.memCacheSize = Math.min(Math.round(percent * (float)Runtime.getRuntime().maxMemory() / 1024.0f), this.maxMemCacheSize);
        }
    }
}

