/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http.net;

import android.content.Context;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.BaseHttpClient;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestIntercepter;
import com.yy.mobile.http.config.IHttpNetConfig;
import com.yy.mobile.http.interceptor.CacheInterceptor;
import com.yy.mobile.http.net.IHttpNet;
import com.yy.mobile.http.net.RequestMonitor;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.util.taskexecutor.YYTaskExecutorHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class HttpNetImp
implements IHttpNet {
    private IHttpNetConfig mConfig = null;
    private List<RequestIntercepter> list = new ArrayList<RequestIntercepter>();
    private AtomicBoolean mInit = new AtomicBoolean(false);

    @Override
    public synchronized void init(@NonNull IHttpNetConfig config) {
        try {
            OkHttpClient.Builder builder = BaseHttpClient.getOkHttpClient().newBuilder();
            if (TextUtils.isEmpty((CharSequence)config.getCacheDir()) && config.getCacheSize() > 0 && config.getContext() != null) {
                String cachePath = BasicConfig.getInstance().isExternalStorageAvailable() || !Environment.isExternalStorageRemovable() ? HttpNetImp.getExternalCacheDir(config.getContext()).getPath() : config.getContext().getCacheDir().getPath();
                File cacheFile = new File(cachePath + File.separator + config.getCacheDir());
                int cacheSize = config.getCacheSize();
                builder.cache(new Cache(cacheFile, (long)cacheSize));
            }
            builder.dispatcher(new Dispatcher((ExecutorService)YYTaskExecutorHelper.INSTANCE.getIOThreadPool()));
            builder.addNetworkInterceptor((Interceptor)new CacheInterceptor());
            if (config.getInterceptors() != null && config.getInterceptors().size() > 0) {
                for (Interceptor interceptor : config.getInterceptors()) {
                    builder.addNetworkInterceptor(interceptor);
                }
            }
            BaseHttpClient.initOkHttpClient(builder.build());
            this.mConfig = config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.mInit.set(true);
    }

    @Override
    public void addRequestIntercepter(@NonNull RequestIntercepter interceptor) {
        if (!this.mInit.get()) {
            throw new RuntimeException("use http addInterceptor but have not init,crash!!!");
        }
        this.mConfig.addRequestIntercepter(interceptor);
    }

    private static File getExternalCacheDir(Context context) {
        return new File(Environment.getExternalStorageDirectory().getPath());
    }

    @Override
    public void asySend(@NonNull Request request) {
        this.asySend(request, YYTaskExecutor.TaskType.NORMAL);
    }

    @Override
    public void asySend(Request request, YYTaskExecutor.TaskType type) {
        if (!this.mInit.get()) {
            throw new RuntimeException("use http asySend but have not init,crash!!!");
        }
        if (this.mConfig != null && this.mConfig.getRequestIntercepters() != null && this.mConfig.getRequestIntercepters().size() > 0) {
            for (RequestIntercepter interceptor : this.mConfig.getRequestIntercepters()) {
                interceptor.onIntercept(request);
            }
        }
        if (request.getTag() == null) {
            request.setTag(request.getUrl());
        }
        YYTaskExecutor.execute((Runnable)new RequestMonitor(request), 0L, 0, type);
    }

    @Override
    public void cancel(Object tag) {
        for (Call call : BaseHttpClient.getOkHttpClient().dispatcher().queuedCalls()) {
            if (!call.request().tag().equals(tag)) continue;
            call.cancel();
        }
        for (Call call : BaseHttpClient.getOkHttpClient().dispatcher().runningCalls()) {
            if (!call.request().tag().equals(tag)) continue;
            call.cancel();
        }
    }
}

