/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.support.annotation.NonNull;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.CacheCleanRequest;
import com.yy.mobile.http.CacheShrinkRequest;
import com.yy.mobile.http.DiskCache;
import com.yy.mobile.http.DownloadRequest;
import com.yy.mobile.http.MultipartPostRequest;
import com.yy.mobile.http.PostRequest;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestIntercepter;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.ResponseParser;
import com.yy.mobile.http.StringPostRequest;
import com.yy.mobile.http.StringQueryRequest;
import com.yy.mobile.http.config.IHttpNetConfig;
import com.yy.mobile.http.net.HttpNetImp;
import com.yy.mobile.http.net.IHttpNet;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.functions.Function;

public class RequestManager {
    private static RequestManager mFactory;
    private Cache mCache;
    private GlobalRequestParameterAppender mGlobalRequestParameterAppender;
    private boolean mInit = false;
    private IHttpNet mHttpNet = new HttpNetImp();
    private boolean mRunOnUI = true;

    private RequestManager() {
    }

    public static synchronized RequestManager instance() {
        if (mFactory == null) {
            mFactory = new RequestManager();
        }
        return mFactory;
    }

    public synchronized void init(IHttpNetConfig config) {
        if (this.mCache == null) {
            this.mCache = new DiskCache(DiskCache.getCacheDir(config.getContext(), config.getCacheDir()), 0x500000L, 0.2f);
            this.mCache.initialize();
        }
        this.mHttpNet.init(config);
        this.mInit = true;
    }

    public void addRequestIntercepter(RequestIntercepter interceptor) {
        if (interceptor != null) {
            this.mHttpNet.addRequestIntercepter(interceptor);
        }
    }

    public void cancel(Object tag) {
        this.mHttpNet.cancel(tag);
    }

    public synchronized void deInit() {
        this.mInit = false;
    }

    public Cache getCache() {
        return this.mCache;
    }

    public <T, R> Single<R> get(final String url, final RequestParam param, final ResponseParser<T, R> parser) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

            public void subscribe(final SingleEmitter<T> e) throws Exception {
                String urlWithQuery = RequestManager.getUrlWithQueryString(url, param, RequestManager.this.mGlobalRequestParameterAppender == null ? null : RequestManager.this.mGlobalRequestParameterAppender.getGlobalAppendRequestParam());
                StringQueryRequest req = new StringQueryRequest(RequestManager.this.mCache, urlWithQuery, new ResponseListener<T>(){

                    @Override
                    public void onResponse(T response) {
                        e.onSuccess(response);
                    }
                }, new ResponseErrorListener(){

                    @Override
                    public void onErrorResponse(RequestError error) {
                        e.onError((Throwable)error);
                    }
                });
                if (param != null && param.getCacheController() != null) {
                    req.setCacheController(param.getCacheController());
                }
                RequestManager.this.submitRequest(req);
            }
        }).map(new Function<T, R>(){

            public R apply(T t) throws Exception {
                return parser.parse(t);
            }
        });
    }

    public <T, R> Single<R> post(final String url, final RequestParam param, final ResponseParser<T, R> parser) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

            public void subscribe(final SingleEmitter<T> e) throws Exception {
                PostRequest req = new PostRequest(url, param, new ResponseListener<T>(){

                    @Override
                    public void onResponse(T response) {
                        e.onSuccess(response);
                    }
                }, new ResponseErrorListener(){

                    @Override
                    public void onErrorResponse(RequestError error) {
                        e.onError((Throwable)error);
                    }
                });
                RequestManager.this.submitRequest(req);
            }
        }).map(new Function<T, R>(){

            public R apply(T t) throws Exception {
                return parser.parse(t);
            }
        });
    }

    public void submitStringQueryRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener) {
        this.submitStringQueryRequest(url, param, false, successListener, errorListener, this.mRunOnUI);
    }

    public void submitStringQueryRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener, boolean runOnUI) {
        this.submitStringQueryRequest(url, param, false, successListener, errorListener, runOnUI);
    }

    public void submitStringQueryRequest(String url, RequestParam param, boolean highPriority, ResponseListener<String> successListener, ResponseErrorListener errorListener) {
        this.submitStringQueryRequest(url, param, highPriority, successListener, errorListener, this.mRunOnUI);
    }

    public void submitStringQueryRequest(@NonNull String url, @NonNull RequestParam param, boolean highPriority, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener, boolean runOnUI) {
        if (url == null || successListener == null || errorListener == null) {
            return;
        }
        url = RequestManager.getUrlWithQueryString(url, param, this.mGlobalRequestParameterAppender == null ? null : this.mGlobalRequestParameterAppender.getGlobalAppendRequestParam());
        StringQueryRequest<String> req = new StringQueryRequest<String>(this.mCache, url, successListener, errorListener);
        req.setRunOnUIThread(runOnUI);
        this.mHttpNet.asySend(req);
    }

    public static String getUrlWithQueryString(String url, RequestParam params) {
        String paramString;
        if (params != null && (paramString = params.getParamString()) != null && paramString.length() > 0) {
            url = url.indexOf("?") == -1 ? url + "?" + paramString : url + "&" + paramString;
        }
        return url;
    }

    public static String getUrlWithQueryString(String url, RequestParam ... requestParams) {
        if (requestParams != null && requestParams.length > 0) {
            for (RequestParam requestParam : requestParams) {
                url = RequestManager.getUrlWithQueryString(url, requestParam);
            }
        }
        return url;
    }

    public void submitMultipartPostRequest(@NonNull String url, @NonNull RequestParam param, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener, ProgressListener progressListener, boolean runOnUI) {
        if (url == null || param == null || successListener == null || errorListener == null) {
            return;
        }
        MultipartPostRequest req = new MultipartPostRequest(url, param, (ResponseListener)successListener, errorListener, progressListener);
        req.setRunOnUIThread(runOnUI);
        this.mHttpNet.asySend(req);
    }

    public void submitMultipartPostRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        this.submitMultipartPostRequest(url, param, successListener, errorListener, progressListener, this.mRunOnUI);
    }

    public void submitMultipartPostRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener) {
        this.submitMultipartPostRequest(url, param, successListener, errorListener, null, this.mRunOnUI);
    }

    public void submitMultipartPostRequest(String url, RequestParam param, ResponseListener<String> successListener, ResponseErrorListener errorListener, boolean runOnUI) {
        this.submitMultipartPostRequest(url, param, successListener, errorListener, null, runOnUI);
    }

    public void submitCrashReportRequest(@NonNull String url, @NonNull RequestParam param, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener, boolean onStartSubmit) {
        if (url == null || param == null || successListener == null || errorListener == null) {
            return;
        }
        MultipartPostRequest req = new MultipartPostRequest(url, param, (ResponseListener)successListener, errorListener);
        this.mHttpNet.asySend(req);
    }

    public void submitDownloadRequest(String url, String downloadFilePath, ResponseListener<String> successListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        this.submitDownloadRequest(url, downloadFilePath, successListener, errorListener, progressListener, false);
    }

    public void submitDownloadGiftRequest(String url, String downloadFilePath, ResponseListener<String> successListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        this.submitDownloadGiftRequest(url, downloadFilePath, successListener, errorListener, progressListener, false, this.mRunOnUI);
    }

    public void submitDownloadRequest(String url, String downloadFilePath, ResponseListener<String> successListener, ResponseErrorListener errorListener, ProgressListener progressListener, boolean useContinueDownload) {
        this.submitDownloadRequest(url, downloadFilePath, successListener, errorListener, progressListener, useContinueDownload, this.mRunOnUI);
    }

    public void submitDownloadRequest(@NonNull String url, @NonNull String downloadFilePath, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener, @NonNull ProgressListener progressListener, boolean useContinueDownload, boolean runOnUI) {
        if (url == null || downloadFilePath == null || successListener == null || errorListener == null || progressListener == null) {
            return;
        }
        DownloadRequest req = new DownloadRequest(url, downloadFilePath, successListener, errorListener, progressListener, useContinueDownload);
        req.setRunOnUIThread(runOnUI);
        this.mHttpNet.asySend(req, YYTaskExecutor.TaskType.IO);
    }

    public void submitDownloadGiftRequest(@NonNull String url, @NonNull String downloadFilePath, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener, @NonNull ProgressListener progressListener, boolean useContinueDownload, boolean runOnUI) {
        if (url == null || downloadFilePath == null || successListener == null || errorListener == null || progressListener == null) {
            return;
        }
        DownloadRequest req = new DownloadRequest(url, downloadFilePath, successListener, errorListener, progressListener, useContinueDownload);
        req.setRunOnUIThread(runOnUI);
        this.mHttpNet.asySend(req, YYTaskExecutor.TaskType.GIFT);
    }

    public void submitCacheCleanRequest(ResponseListener<Object> successListener, ResponseErrorListener errorListener) {
        CacheCleanRequest req = new CacheCleanRequest(this.mCache, successListener, errorListener);
        this.mHttpNet.asySend(req);
    }

    public void submitCacheShrinkRequest(ResponseListener<Object> successListener, ResponseErrorListener errorListener) {
        CacheShrinkRequest req = new CacheShrinkRequest(this.mCache, successListener, errorListener);
        this.mHttpNet.asySend(req);
    }

    public void submitStringPostJsonRequest(@NonNull String url, String toJson, String contentType, @NonNull RequestParam param, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener, boolean runOnUI) {
        if (url == null || param == null || successListener == null || errorListener == null) {
            return;
        }
        StringPostRequest<String> req = new StringPostRequest<String>(url, param, successListener, errorListener);
        req.setRunOnUIThread(runOnUI);
        req.setContentType(contentType);
        req.setString(toJson);
        this.mHttpNet.asySend(req);
    }

    public void submitStringPostJsonRequest(@NonNull String url, String toJson, @NonNull RequestParam param, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener) {
        this.submitStringPostJsonRequest(url, toJson, "application/json", param, successListener, errorListener, this.mRunOnUI);
    }

    public void submitStringPostJsonRequest(@NonNull String url, String toJson, @NonNull RequestParam param, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener, boolean runOnUI) {
        this.submitStringPostJsonRequest(url, toJson, "application/json", param, successListener, errorListener, runOnUI);
    }

    public void submitStringPostJsonRequest(@NonNull String url, @NonNull String toJson, String contentType, RequestParam param, @NonNull ResponseListener<String> successListener, @NonNull ResponseErrorListener errorListener) {
        this.submitStringPostJsonRequest(url, toJson, contentType, param, successListener, errorListener, this.mRunOnUI);
    }

    public void submitRequest(Request req) {
        if (!req.hasSetRunOnUIThread()) {
            req.setRunOnUIThread(this.mRunOnUI);
        }
        this.mHttpNet.asySend(req);
    }

    public void setGlobalRequestParameterAppender(GlobalRequestParameterAppender appender) {
        this.mGlobalRequestParameterAppender = appender;
    }

    public boolean isInit() {
        return this.mInit;
    }

    public void setRunOnUI(boolean b) {
        this.mRunOnUI = b;
    }

    public static interface GlobalRequestParameterAppender {
        public RequestParam getGlobalAppendRequestParam();
    }
}

