/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.Cache;
import com.yy.mobile.http.DefaultRetryPolicy;
import com.yy.mobile.http.DownloadContinueNetwork;
import com.yy.mobile.http.DownloadNetwork;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.NoCache;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.http.StringQueryRequest;

public class DownloadRequest<String>
extends StringQueryRequest {
    private static final int TIMEOUT_MS = 5000;
    private static final int MAX_RETRIES = 2;
    private static final float BACKOFF_MULT = 1.0f;
    public static final String THRESHOLD_TYPE = "HighTraffic";

    public DownloadRequest(String url, String downloadFilePath, ResponseListener successListener, ResponseErrorListener errorListener, ProgressListener progressListener, boolean useContinueDownload) {
        super((Cache)new NoCache(), url, successListener, errorListener);
        this.mProgressListener = progressListener;
        if (downloadFilePath == null || downloadFilePath.length() == 0) {
            HttpLog.e("DownloadFilePath is empty.", new Object[0]);
            return;
        }
        this.mNetwork = useContinueDownload ? new DownloadContinueNetwork(downloadFilePath) : new DownloadNetwork(downloadFilePath);
        this.setShouldCache(false);
        this.setRetryPolicy(new DefaultRetryPolicy(5000, 2, 1.0f));
    }

    @Override
    public int getThreshold() {
        return 2;
    }

    @Override
    public String getThresholdType() {
        return THRESHOLD_TYPE;
    }
}

