/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.DownloadContinueConfig;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.ResponseData;
import com.yy.mobile.http.ServerError;
import com.yy.mobile.util.YYFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import okhttp3.Response;

public class DownloadContinueNetwork
extends BaseNetwork {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final String TMP_SURFIX = ".tmp";
    public static final String CONFIG_SURFIX = ".cfg";
    public static final String DOWNLOAD_KEY_PROGRESS = "PROGRESS";
    public static final String CONTENT_RANGE = "Content-Range";
    protected String mDownloadFilePath;
    protected String mDownloadFileTempPath;
    protected String mDownloadFileConfigPath;
    protected RandomAccessFile mRandomAccessFile;
    protected DownloadContinueConfig mDownloadContinueConfig;

    public DownloadContinueNetwork(String downloadFilePath) {
        HttpLog.v("Download file path " + downloadFilePath, new Object[0]);
        this.mDownloadFilePath = downloadFilePath;
        this.mDownloadFileTempPath = DownloadContinueNetwork.createTempPath(this.mDownloadFilePath);
        this.mDownloadFileConfigPath = DownloadContinueNetwork.createConfigPath(this.mDownloadFilePath);
    }

    protected static String createTempPath(String orginalPath) {
        String fileName = TMP_SURFIX;
        fileName = orginalPath.concat(fileName);
        return fileName;
    }

    public static String createConfigPath(String orginalPath) {
        String fileName = CONFIG_SURFIX;
        fileName = orginalPath.concat(fileName);
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResponseData performRequest(Request<?> request) throws RequestError {
        ResponseData data;
        try {
            File tempFile = new File(this.mDownloadFileTempPath);
            this.mDownloadContinueConfig = new DownloadContinueConfig(this.mDownloadFileConfigPath);
            if (tempFile.exists()) {
                if (this.mDownloadContinueConfig.exists()) {
                    this.mDownloadContinueConfig.load();
                    int lastProgress = this.mDownloadContinueConfig.getInt(DownloadContinueNetwork.getProgressKey(), 0);
                    HttpLog.v("Last progress = " + lastProgress, new Object[0]);
                    request.getHeaders().put("Range", "bytes=" + lastProgress + "-");
                } else {
                    this.mDownloadContinueConfig.create();
                    this.mDownloadContinueConfig.put(DownloadContinueNetwork.getProgressKey(), "0");
                    this.mDownloadContinueConfig.save();
                }
            } else {
                try {
                    File tmpFile = YYFileUtils.createFile(tempFile.getPath()).getFile();
                    if (tmpFile != null) {
                        tempFile = tmpFile;
                    }
                }
                catch (Exception e) {
                    HttpLog.e("Create download config error:" + this.mDownloadFileTempPath, new Object[0]);
                }
                if (this.mDownloadContinueConfig.exists()) {
                    this.mDownloadContinueConfig.delete();
                }
                this.mDownloadContinueConfig.create();
                this.mDownloadContinueConfig.put(DownloadContinueNetwork.getProgressKey(), "0");
                this.mDownloadContinueConfig.save();
            }
            this.mRandomAccessFile = new RandomAccessFile(tempFile, "rwd");
        }
        catch (Exception e) {
            HttpLog.e(e, "Load config file error", new Object[0]);
        }
        ResponseData responseData = data = super.performRequest(request);
        if (this.mRandomAccessFile == null) return responseData;
        try {
            this.mRandomAccessFile.close();
            return responseData;
        }
        catch (IOException e) {
            HttpLog.e(e, "RandomAccessFile close error", e);
        }
        return responseData;
        catch (Exception e) {
            try {
                HttpLog.e("DownloadContinueNetwork", e);
                if (this.mRandomAccessFile == null) return null;
            }
            catch (Throwable throwable) {
                if (this.mRandomAccessFile == null) throw throwable;
                try {
                    this.mRandomAccessFile.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    HttpLog.e(e2, "RandomAccessFile close error", e2);
                }
                throw throwable;
            }
            try {
                this.mRandomAccessFile.close();
                return null;
            }
            catch (IOException e3) {
                HttpLog.e(e3, "RandomAccessFile close error", e3);
            }
            return null;
        }
    }

    public static String getProgressKey() {
        return DOWNLOAD_KEY_PROGRESS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] entityToBytes(Request<?> request, Response response) throws IOException, ServerError {
        block19: {
            statusCode = response.code();
            if (statusCode < 200 || statusCode > 299) {
                tempFile = new File(this.mDownloadFileTempPath);
                if (tempFile == null) return super.entityToBytes(request, response);
                if (tempFile.exists() == false) return super.entityToBytes(request, response);
                tempFile.delete();
                return super.entityToBytes(request, response);
            }
            seekLocation = this.seekLocationAndReturn(response);
            buffer = new byte[4096];
            progress = seekLocation;
            in = response.body().byteStream();
            outputStreamWriter = this.mDownloadContinueConfig.getWriter();
            try {
                if (in == null) {
                    throw new ServerError();
                }
                contentLength = response.body().contentLength();
                total = contentLength + (long)seekLocation;
                HttpLog.v("Download content length %d", new Object[]{total});
lbl20:
                // 3 sources

                while ((count = in.read(buffer)) != -1) {
                    this.mRandomAccessFile.write(buffer, 0, count);
                    this.mDownloadContinueConfig.put(DownloadContinueNetwork.getProgressKey(), String.valueOf(progress += (long)count));
                    this.mDownloadContinueConfig.store(outputStreamWriter);
                    if (request.isCanceled()) {
                        HttpLog.v("Download cancel.", new Object[0]);
                        this.onCancel(progress);
                        var15_14 = new byte[]{};
                        break block19;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl61
            }
            catch (IOException e) {
                try {
                    if (this.mDownloadContinueConfig.exists() == false) throw e;
                    this.mDownloadContinueConfig.put(DownloadContinueNetwork.getProgressKey(), String.valueOf(progress));
                    this.mDownloadContinueConfig.save();
                    throw e;
                }
                catch (Throwable var18_19) {
                    try {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                        in.close();
                        response.body().close();
                        throw var18_19;
                    }
                    catch (IOException e) {
                        HttpLog.e("DownloadContinueNetwork steam close error", new Object[]{e});
                    }
                    throw var18_19;
                }
            }
        }
        try {
            outputStreamWriter.flush();
            outputStreamWriter.close();
            in.close();
            response.body().close();
            return var15_14;
        }
        catch (IOException e) {
            HttpLog.e("DownloadContinueNetwork steam close error", new Object[]{e});
        }
        return var15_14;
lbl-1000:
        // 1 sources

        {
            if (!this.needProgress(count, total, request, progress)) ** GOTO lbl20
            progressInfo = new ProgressInfo(progress, total);
            request.postProgress(progressInfo);
            ** GOTO lbl20
lbl61:
            // 1 sources

            HttpLog.v("File download completed", new Object[0]);
            renameResult = new File(this.mDownloadFileTempPath).renameTo(new File(this.mDownloadFilePath));
            HttpLog.v("File rename completed, result = " + renameResult, new Object[0]);
            if (this.mDownloadContinueConfig.delete()) {
                HttpLog.v("Config File delete completed", new Object[0]);
            } else {
                HttpLog.e("Config File delete fail", new Object[0]);
            }
            if (!renameResult) {
                throw new IOException("File rename fail");
            }
            if (contentLength != 0L && progress < total) {
                throw new ServerError("Download progress less than contentLength " + progress + "/" + contentLength);
            }
            var16_17 = this.mDownloadFilePath.getBytes();
        }
        try {
            outputStreamWriter.flush();
            outputStreamWriter.close();
            in.close();
            response.body().close();
            return var16_17;
        }
        catch (IOException e) {
            HttpLog.e("DownloadContinueNetwork steam close error", new Object[]{e});
        }
        return var16_17;
    }

    public int seekLocationAndReturn(Response response) throws IOException {
        String rangeValue;
        String[] rangeValues;
        int seekLocation = 0;
        if (response.header(CONTENT_RANGE) != null && (rangeValues = (rangeValue = response.header(CONTENT_RANGE)).split(" ")).length > 1 && rangeValues[1].contains("-")) {
            String bytesString = rangeValues[1].split("-")[0];
            try {
                seekLocation = Integer.parseInt(bytesString);
            }
            catch (NumberFormatException e) {
                HttpLog.e(e, "Range number parse error", new Object[0]);
            }
            HttpLog.v("SeekLocation = " + seekLocation, new Object[0]);
            this.mRandomAccessFile.seek(seekLocation);
        }
        return seekLocation;
    }

    protected void onCancel(long progress) throws IOException {
        HttpLog.v("OnCancel", new Object[0]);
        this.mDownloadContinueConfig.put(DownloadContinueNetwork.getProgressKey(), String.valueOf(progress));
        this.mDownloadContinueConfig.save();
        this.abort();
    }
}

