/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.widget.TextView;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MobileNumberUtil {
    private static final String REG_CHINA_MOBILE = "^1(3[4-9]|47|5[012789]|8[2378])\\d{8}$";
    private static final String REG_CHINA_UNICOM = "^1(3[0-2]|5[456]|8[56])\\d{8}$";
    private static final String REG_CHINA_TELECOM = "^1(33|53|8[019])\\d{8}$";
    private static final String REG_CHINA_INTERNAL = "^1(3[0-9]|47|5[0-9]|8[023456789])\\d{8}$";

    public static void hightLightChineseMobileNumber(int c, String text, TextView targetTv) {
        String reg = "\\d{11}";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            SpannableString s = new SpannableString((CharSequence)text);
            ForegroundColorSpan blue = new ForegroundColorSpan(c);
            s.setSpan((Object)blue, matcher.start(), matcher.end(), 18);
            targetTv.setText((CharSequence)s);
        } else {
            targetTv.setText((CharSequence)text);
        }
    }

    public static boolean isChinaMobileNumber(CharSequence phoneNumber) {
        Pattern pattern = Pattern.compile(REG_CHINA_MOBILE);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    public static boolean isChinaUnicomNumber(CharSequence phoneNumber) {
        Pattern pattern = Pattern.compile(REG_CHINA_UNICOM);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    public static boolean isChinaTelecomNumber(CharSequence phoneNumber) {
        Pattern pattern = Pattern.compile(REG_CHINA_TELECOM);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    public static boolean isChinaInternalNumber(CharSequence phoneNumber) {
        Pattern pattern = Pattern.compile(REG_CHINA_INTERNAL);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }
}

