/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpsUrlHelpers {
    private static final String IM_HTTPS_UPLOAD_PREFIX = "https://imss.yy.com";
    private static final String IM_HTTPS_DOWN_REGEX_PATTERN = "(https:\\/\\/imss\\.yy\\.com\\/down_ss\\.php\\?target=[0-9a-f]\\.((dx)|(wt))imscreenshot[0-9a-f]?\\.yy\\.((yystatic)|(duowan))\\.com(:[0-9]+)?&uri=\\/)|(https:\\/\\/outlinkfile\\.bs2dl\\.yy\\.com(:[0-9]+)?\\/)";
    private static final String IM_HTTP_DOWN_REGEX_PATTERN = "(http:\\/\\/[0-9a-f]\\.((dx)|(wt))imscreenshot[0-9a-f]?\\.yy\\.((yystatic)|(duowan))\\.com(:[0-9]+)?\\/)";

    public static String translateToValidHttpsImDownUrl(String url) {
        boolean isMatch = false;
        Pattern pattern = Pattern.compile(IM_HTTPS_DOWN_REGEX_PATTERN);
        Matcher matcher = pattern.matcher(url);
        isMatch = matcher.find();
        if (isMatch) {
            return url;
        }
        pattern = Pattern.compile(IM_HTTP_DOWN_REGEX_PATTERN);
        matcher = pattern.matcher(url);
        isMatch = matcher.find();
        if (isMatch) {
            StringBuilder https = new StringBuilder("https://imss.yy.com/down_ss.php?target=");
            String httpPrefix = "http://";
            String httpSub = url.substring(httpPrefix.length());
            int index = httpSub.indexOf("/");
            String target = httpSub.substring(0, index);
            String uri = httpSub.substring(index);
            https.append(target);
            https.append("&uri=");
            https.append(uri);
            String httpsUrl = https.toString();
            return httpsUrl;
        }
        return url;
    }

    public static class ImMediaUploadPath {
        private static final String IMAGE = "/user_upl.php";
        private static final String SMILE = "/user_sml.php";
        private static final String AUDIO = "/user_snd.php";
    }

    public static enum ImMediaType {
        IMAGE(0),
        SMILE(1),
        AUDIO(2);

        private int number;

        private ImMediaType(int number) {
            this.number = number;
        }

        public int number() {
            return this.number;
        }
    }
}

