/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.content.Context;
import android.util.Log;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    private static final String TAG = "FileUtil";
    public static final String EXT_BAK = ".bak";
    public static final byte WRITE_POS_CURRENT_POS = 0;
    public static final byte WRITE_POS_BEGIN = 1;
    public static final byte WRITE_POS_END = 2;
    public static final byte WRITE_POS_SPECIFIED = 3;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] mCs = new String[]{"/", "\\", "?", "*", ":", "<", ">", "|", "\""};
    private static final char UNICODE_SURROGATE_START_CHAR = '\ud800';
    private static final char UNICODE_SURROGATE_END_CHAR = '\udfff';

    public static File[] unzip(String zip, String passwd) throws IOException {
        File zipFile = new File(zip);
        File parentDir = zipFile.getParentFile();
        return FileUtil.unzip(zipFile, parentDir.getAbsolutePath(), passwd);
    }

    public static File[] unzip(String zip, String dest, String passwd) throws IOException {
        File zipFile = new File(zip);
        return FileUtil.unzip(zipFile, dest, passwd);
    }

    public static File[] unzip(File zipFile, String dest, String passwd) throws IOException {
        ZipEntry zipEntry;
        File destDir;
        if (FP.empty(dest)) {
            throw new IOException();
        }
        if (!dest.endsWith(File.separator)) {
            dest = dest + File.separator;
        }
        if (!(destDir = new File(dest)).isDirectory() || !destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream inZip = new ZipInputStream(new FileInputStream(zipFile.getPath()));
        String szName = "";
        ArrayList<File> extractedFileList = new ArrayList<File>();
        while ((zipEntry = inZip.getNextEntry()) != null) {
            int len;
            szName = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                szName = szName.substring(0, szName.length() - 1);
                File folder = new File(destDir + File.separator + szName);
                folder.mkdirs();
                continue;
            }
            File file = new File(destDir + File.separator + szName);
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = inZip.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                out.flush();
            }
            out.close();
            extractedFileList.add(file);
        }
        inZip.close();
        File[] extractedFiles = new File[extractedFileList.size()];
        extractedFileList.toArray(extractedFiles);
        return extractedFiles;
    }

    public static File[] unzip(Context context, String assetName, String dest) throws IOException {
        ZipEntry zipEntry;
        File destDir;
        if (FP.empty(dest)) {
            throw new IOException();
        }
        if (!dest.endsWith(File.separator)) {
            dest = dest + File.separator;
        }
        if (!(destDir = new File(dest)).isDirectory() || !destDir.exists()) {
            destDir.mkdir();
        }
        InputStream inputStream = context.getAssets().open(assetName);
        ZipInputStream inZip = new ZipInputStream(inputStream);
        String szName = "";
        ArrayList<File> extractedFileList = new ArrayList<File>();
        while ((zipEntry = inZip.getNextEntry()) != null) {
            int len;
            szName = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                szName = szName.substring(0, szName.length() - 1);
                File folder = new File(destDir + File.separator + szName);
                folder.mkdirs();
                continue;
            }
            File file = new File(destDir + File.separator + szName);
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = inZip.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                out.flush();
            }
            out.close();
            extractedFileList.add(file);
        }
        inZip.close();
        File[] extractedFiles = new File[extractedFileList.size()];
        extractedFileList.toArray(extractedFiles);
        return extractedFiles;
    }

    public static void removeDir(String dirPath) {
        File[] fileList;
        File dir = new File(dirPath);
        if (dir.isDirectory() && (fileList = dir.listFiles()) != null && fileList.length > 0) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    FileUtil.removeDir(file.getAbsolutePath());
                }
                file.delete();
            }
        }
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_DIGITS[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_DIGITS[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static String getFileMd5(String fileFullPath) throws Exception {
        if (StringUtils.isEmpty(fileFullPath).booleanValue()) {
            throw new IOException("fillPath empty!");
        }
        FileInputStream fis = null;
        byte[] buffer = new byte[4096];
        int numRead = 0;
        MessageDigest md5 = null;
        try {
            fis = new FileInputStream(fileFullPath);
            md5 = MessageDigest.getInstance("MD5");
            while ((numRead = ((InputStream)fis).read(buffer)) != -1) {
                md5.update(buffer, 0, numRead);
            }
            String string2 = FileUtil.toHexString(md5.digest());
            return string2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (IOException e2) {
                Log.e((String)TAG, (String)"Empty Catch on getFileMd5", (Throwable)e2);
            }
        }
    }

    public static boolean isFileNameCorrect(String fileName) {
        if (null == fileName) {
            return false;
        }
        if ((fileName = fileName.trim()).length() == 0) {
            return false;
        }
        for (String c : mCs) {
            if (!fileName.contains(c)) continue;
            return false;
        }
        return !FileUtil.containsSurrogateChar(fileName);
    }

    public static String fixFileName(String fileName) {
        if (null == fileName) {
            return null;
        }
        String result = fileName.toString();
        for (String c : mCs) {
            result = result.replace(c, "");
        }
        if (FileUtil.containsSurrogateChar(result)) {
            result = FileUtil.removeSurrogateChars(result);
        }
        return result;
    }

    public static String removeSurrogateChars(String string2) {
        if (StringUtils.isEmpty(string2).booleanValue()) {
            return string2;
        }
        int length = string2.length();
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            if (c >= '\ud800' && c <= '\udfff') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean containsSurrogateChar(String string2) {
        if (StringUtils.isEmpty(string2).booleanValue()) {
            return false;
        }
        int length = string2.length();
        boolean hasSurrogateChar = false;
        for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            if ('\ud800' > c || c > '\udfff') continue;
            hasSurrogateChar = true;
            break;
        }
        return hasSurrogateChar;
    }

    public static boolean deleteFile(String filePath, String fileName) {
        if (StringUtils.isEmpty(filePath).booleanValue() || StringUtils.isEmpty(fileName).booleanValue()) {
            return false;
        }
        File dir = new File(filePath);
        File fileToDelete = new File(dir, fileName);
        if (fileToDelete.exists() && fileToDelete.isFile()) {
            return fileToDelete.delete();
        }
        return true;
    }

    public static boolean writeBytes(String filePath, String fileName, byte[] data) {
        if (data == null) {
            return false;
        }
        return FileUtil.writeBytes(filePath, fileName, data, 0, data.length);
    }

    public static File createNewFile(String path, boolean append) {
        File newFile = new File(path);
        if (!append && newFile.exists()) {
            newFile.delete();
        }
        if (!newFile.exists()) {
            try {
                File parent = newFile.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                newFile.createNewFile();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Empty Catch on createNewFile", (Throwable)e);
            }
        }
        return newFile;
    }

    public static File createNewFile(String path) {
        return FileUtil.createNewFile(path, false);
    }

    public static String genBackupFilePath(String filePath) {
        return filePath + EXT_BAK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytesBase(File file, byte[] headData, byte[] bodyData, int bodyOffset, int bodyLen, boolean forceFlush) throws FileNotFoundException, IOException {
        boolean bl;
        FileOutputStream fileOutput = null;
        try {
            FileDescriptor fd;
            fileOutput = new FileOutputStream(file);
            if (headData != null) {
                fileOutput.write(headData);
            }
            fileOutput.write(bodyData, bodyOffset, bodyLen);
            fileOutput.flush();
            if (forceFlush && (fd = fileOutput.getFD()) != null) {
                fd.sync();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(fileOutput);
            throw throwable;
        }
        FileUtil.safeClose(fileOutput);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytesToFile(File file, byte[] data, boolean append, boolean forceFlush) throws IOException {
        boolean bl;
        if (data == null || file == null) {
            return false;
        }
        if (!file.exists()) {
            try {
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Empty Catch on createNewFile", (Throwable)e);
            }
        }
        FileOutputStream fileOutput = null;
        try {
            FileDescriptor fd;
            fileOutput = new FileOutputStream(file, append);
            fileOutput.write(data, 0, data.length);
            fileOutput.flush();
            if (forceFlush && (fd = fileOutput.getFD()) != null) {
                fd.sync();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(fileOutput);
            throw throwable;
        }
        FileUtil.safeClose(fileOutput);
        return bl;
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Empty Catch on safeClose", (Throwable)e);
            }
        }
    }

    public static boolean delete(String path) {
        return FileUtil.delete(new File(path));
    }

    public static boolean delete(File file) {
        String[] children;
        if (file.isDirectory() && (children = file.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.delete(new File(file, children[i]));
                if (success) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean isFileExist(String filePath) {
        if (filePath != null && filePath.length() > 0) {
            try {
                File file = new File(filePath);
                return file.exists();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static String getFileFullPath(String filePath, String fileName) {
        File file = new File(filePath, fileName);
        return file.getPath();
    }

    public static boolean writeBytes(String filePath, String fileName, byte[] headData, byte[] bodyData, int bodyOffset, int bodyLen, boolean forceFlush) throws FileNotFoundException, IOException {
        if (StringUtils.isEmpty(filePath).booleanValue() || StringUtils.isEmpty(fileName).booleanValue() || bodyData == null) {
            return false;
        }
        String tempFileName = System.currentTimeMillis() + fileName;
        File tempFile = FileUtil.createNewFile(FileUtil.getFileFullPath(filePath, tempFileName));
        boolean result = FileUtil.writeBytesBase(tempFile, headData, bodyData, bodyOffset, bodyLen, forceFlush);
        if (!result) {
            return false;
        }
        String srcPath = FileUtil.getFileFullPath(filePath, fileName);
        if (!FileUtil.rename(tempFile, srcPath)) {
            String bakPath = FileUtil.genBackupFilePath(srcPath);
            FileUtil.delete(bakPath);
            FileUtil.rename(new File(srcPath), bakPath);
            result = FileUtil.rename(tempFile, srcPath);
            if (!result) {
                return false;
            }
            FileUtil.delete(bakPath);
        }
        return true;
    }

    public static boolean rename(File file, String newName) {
        return file.renameTo(new File(newName));
    }

    public static boolean writeBytes(RandomAccessFile raf, byte mode, int specifiedPos, byte[] data) {
        if (null == raf || data == null || data.length == 0) {
            return false;
        }
        try {
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    raf.seek(0L);
                    break;
                }
                case 2: {
                    long len = raf.length();
                    raf.seek(len);
                    break;
                }
                case 3: {
                    raf.seek(specifiedPos);
                    break;
                }
            }
            raf.write(data);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static boolean writeBytes(String filePath, String fileName, byte[] data, int offset, int len) {
        try {
            return FileUtil.writeBytes(filePath, fileName, null, data, offset, len, false);
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"Empty Catch on writeBytes", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Empty Catch on writeBytes", (Throwable)e);
        }
        return false;
    }

    public static byte[] readBytes(String filePath) {
        if (StringUtils.isEmpty(filePath).booleanValue()) {
            return null;
        }
        return FileUtil.readBytes(new File(filePath));
    }

    public static byte[] readBytes(File file) {
        FileInputStream fileInput;
        block4: {
            byte[] byArray;
            fileInput = null;
            try {
                if (!file.exists()) break block4;
                fileInput = new FileInputStream(file);
                byArray = FileUtil.readFullBytes(fileInput);
            }
            catch (Exception e) {
                try {
                    Log.e((String)TAG, (String)"Empty Catch on readBytes", (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtil.safeClose(fileInput);
                    fileInput = null;
                    throw throwable;
                }
                FileUtil.safeClose(fileInput);
                fileInput = null;
            }
            FileUtil.safeClose(fileInput);
            fileInput = null;
            return byArray;
        }
        FileUtil.safeClose(fileInput);
        fileInput = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFullBytes(InputStream input) {
        if (input == null) {
            return null;
        }
        byte[] inputStreamBuffer = new byte[32768];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        try {
            int offset = 0;
            while ((offset = input.read(inputStreamBuffer, 0, inputStreamBuffer.length)) > 0) {
                baos.write(inputStreamBuffer, 0, offset);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Empty Catch on readFullBytes", (Throwable)e);
        }
        finally {
            FileUtil.safeClose(baos);
            baos = null;
        }
        return null;
    }

    public static boolean isDirContainFile(String dirPath, String fileName) {
        try {
            File rootFile = new File(dirPath);
            if (!rootFile.exists() || !rootFile.isDirectory()) {
                return false;
            }
            File[] childFiles = rootFile.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                return false;
            }
            for (File file : childFiles) {
                if (!file.getName().equals(fileName)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "[hasDirectChildSuffixFile] throwable=" + throwable, new Object[0]);
        }
        return false;
    }

    public static boolean isDirContainFile(File rootFile, String fileName) {
        try {
            if (rootFile == null || !rootFile.exists() || !rootFile.isDirectory()) {
                return false;
            }
            File[] childFiles = rootFile.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                return false;
            }
            for (File file : childFiles) {
                if (!file.getName().equals(fileName)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "[hasDirectChildSuffixFile] throwable=" + throwable, new Object[0]);
        }
        return false;
    }
}

