/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.arclayout;

import android.view.animation.Animation;
import android.view.animation.Transformation;

public class RotateAndTranslateAnimation
extends Animation {
    private int mFromXType = 0;
    private int mToXType = 0;
    private int mFromYType = 0;
    private int mToYType = 0;
    private float mFromXValue = 0.0f;
    private float mToXValue = 0.0f;
    private float mFromYValue = 0.0f;
    private float mToYValue = 0.0f;
    private float mFromXDelta;
    private float mToXDelta;
    private float mFromYDelta;
    private float mToYDelta;
    private float mFromDegrees;
    private float mToDegrees;
    private int mPivotXType = 0;
    private int mPivotYType = 0;
    private float mPivotXValue = 0.0f;
    private float mPivotYValue = 0.0f;
    private float mPivotX;
    private float mPivotY;

    public RotateAndTranslateAnimation(float fromXDelta, float toXDelta, float fromYDelta, float toYDelta, float fromDegrees, float toDegrees) {
        this.mFromXValue = fromXDelta;
        this.mToXValue = toXDelta;
        this.mFromYValue = fromYDelta;
        this.mToYValue = toYDelta;
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
        this.mFromDegrees = fromDegrees;
        this.mToDegrees = toDegrees;
        this.mPivotXValue = 0.5f;
        this.mPivotXType = 1;
        this.mPivotYValue = 0.5f;
        this.mPivotYType = 1;
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float dx = this.mFromXDelta;
        float dy = this.mFromYDelta;
        if (this.mFromXDelta != this.mToXDelta) {
            dx = this.mFromXDelta + (this.mToXDelta - this.mFromXDelta) * interpolatedTime;
        }
        if (this.mFromYDelta != this.mToYDelta) {
            dy = this.mFromYDelta + (this.mToYDelta - this.mFromYDelta) * interpolatedTime;
        }
        t.getMatrix().postTranslate(dx, dy);
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mFromXDelta = this.resolveSize(this.mFromXType, this.mFromXValue, width, parentWidth);
        this.mToXDelta = this.resolveSize(this.mToXType, this.mToXValue, width, parentWidth);
        this.mFromYDelta = this.resolveSize(this.mFromYType, this.mFromYValue, height, parentHeight);
        this.mToYDelta = this.resolveSize(this.mToYType, this.mToYValue, height, parentHeight);
        this.mPivotX = this.resolveSize(this.mPivotXType, this.mPivotXValue, width, parentWidth);
        this.mPivotY = this.resolveSize(this.mPivotYType, this.mPivotYValue, height, parentHeight);
    }
}

