/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.app.Activity;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.yy.mobile.ui.widget.ViewContainer;

public abstract class PopupView
extends ViewContainer {
    protected boolean mPopupShown = false;
    protected View mAnchor;
    protected PopupWindow mPopup;

    public PopupView(Activity context) {
        super(context);
    }

    protected void createPopup() {
        this.mPopup = new PopupWindow(this.getContext());
        this.mPopup.setWidth(-1);
        this.mPopup.setHeight(-2);
        this.mPopup.setContentView(this.getView());
        this.mPopup.setInputMethodMode(2);
        this.mPopup.setFocusable(true);
        this.mPopup.setOutsideTouchable(true);
        this.mPopup.setTouchable(true);
        this.mPopup.setAnimationStyle(0);
    }

    public void show(View anchor) {
        this.show(anchor, 0, 0);
    }

    public void show(View anchor, int xOffset, int yOffset) {
        if (this.mPopup == null) {
            this.createPopup();
        }
        this.mAnchor = anchor;
        this.mPopupShown = true;
        this.mPopup.showAsDropDown(anchor, xOffset, yOffset);
    }

    public void showAbove(View anchor) {
        if (this.mPopup == null) {
            this.createPopup();
        }
        this.mAnchor = anchor;
        this.mPopupShown = true;
        int[] pos = new int[2];
        anchor.getLocationInWindow(pos);
        this.mPopup.showAtLocation(anchor, 51, pos[0], pos[1] - this.getViewHeight());
    }

    public void showInCenterTop(View anchor) {
        if (this.mPopup == null) {
            this.createPopup();
        }
        this.mAnchor = anchor;
        this.mPopupShown = true;
        int[] pos = new int[2];
        anchor.getLocationOnScreen(pos);
        this.mPopup.showAtLocation(anchor, 49, 0, pos[1]);
    }

    public void showInCenter(View anchor) {
        if (this.mPopup == null) {
            this.createPopup();
        }
        this.mAnchor = anchor;
        this.mPopupShown = true;
        int[] pos = new int[2];
        anchor.getLocationInWindow(pos);
        this.mPopup.showAtLocation(anchor, 17, 0, 0);
    }

    public void dismiss() {
        if (this.mPopup == null) {
            return;
        }
        this.mPopupShown = false;
        this.mPopup.dismiss();
    }

    public void setAnim(int n) {
        this.mPopup.setAnimationStyle(n);
    }

    public boolean isPopupShown() {
        return this.mPopupShown;
    }

    public View getAnchor() {
        return this.mAnchor;
    }

    protected int getViewHeight() {
        int h = this.getView().getHeight();
        if (h == 0) {
            DisplayMetrics metrics = new DisplayMetrics();
            ((WindowManager)this.getView().getContext().getSystemService("window")).getDefaultDisplay().getMetrics(metrics);
            this.getView().measure(View.MeasureSpec.makeMeasureSpec((int)metrics.widthPixels, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)metrics.heightPixels, (int)Integer.MIN_VALUE));
            h = this.getView().getMeasuredHeight();
        }
        return h;
    }
}

