/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import com.yy.mobile.richtext.ChannelAirTicketParser;
import com.yy.mobile.richtext.NewChannelTicketFilter;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NewChannelAirTicketFilter
extends NewChannelTicketFilter {
    private AirSpanClickListener airClickListener;
    private static final String NUMBER_REG = "[0-9]+";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");

    public NewChannelAirTicketFilter(int id2, AirSpanClickListener listener) {
        super(id2);
        this.airClickListener = listener;
    }

    public static List<ChannelTicketInfo> parseChannelTicket(String msg) {
        ArrayList<ChannelTicketInfo> infoList = new ArrayList<ChannelTicketInfo>();
        CharSequence complateFormatMsg = ChannelAirTicketParser.parseCompleteFormatMsg(msg);
        Matcher matcher = ChannelAirTicketParser.AIR_TICKET_PATTERN.matcher(complateFormatMsg);
        while (matcher.find()) {
            String channelMsg = complateFormatMsg.toString().substring(matcher.start(), matcher.end());
            Matcher m = NUMBER_PATTERN.matcher(channelMsg);
            long sid = 0L;
            long subSid = 0L;
            try {
                if (m.find()) {
                    sid = Long.parseLong(channelMsg.substring(m.start(), m.end()));
                }
                if (channelMsg.contains("subid=") && m.find()) {
                    subSid = Long.parseLong(channelMsg.substring(m.start(), m.end()));
                }
            }
            catch (NumberFormatException e) {
                MLog.error((Object)"hjinw", "parse Channel sid or subSid error :%s", e, new Object[0]);
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug("hjinw", "sid = %d, subSid = %d", sid, subSid);
            }
            infoList.add(new ChannelTicketInfo(matcher.start(), matcher.end(), sid, subSid));
        }
        return infoList;
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        if (!NewChannelAirTicketFilter.isChannelTicketMessage((CharSequence)spannable)) {
            return;
        }
        if (this.ticketDrawable == null) {
            this.ticketDrawable = this.getTicketDrawable(context);
        }
        this.setSpannable(spannable, context);
    }

    private void setSpannable(Spannable spannable, Context context) {
        List<ChannelTicketInfo> infos = NewChannelAirTicketFilter.parseChannelTicket(spannable.toString());
        for (ChannelTicketInfo info : infos) {
            String s = spannable.toString();
            StringBuilder sb = new StringBuilder(s);
            sb.replace(info.start, info.end, "{air}\u70b9\u51fb\u8fdb\u5165" + info.sid + "\u623f\u95f4");
            SpannableString spannable1 = new SpannableString((CharSequence)sb);
            spannable1.setSpan((Object)new CustomImageSpan(this.ticketDrawable, 2, ResolutionUtils.convertDpToPixel(6.0f, context), ResolutionUtils.convertDpToPixel(6.0f, context)), 0, "{air}".length(), 33);
            spannable = spannable1;
        }
    }

    @Override
    public SpannableStringBuilder filterSpan(Context context, SpannableStringBuilder spannable) {
        if (!NewChannelAirTicketFilter.isChannelTicketMessage((CharSequence)spannable)) {
            return spannable;
        }
        if (this.ticketDrawable == null) {
            this.ticketDrawable = this.getTicketDrawable(context);
        }
        List<ChannelTicketInfo> infos = NewChannelAirTicketFilter.parseChannelTicket(spannable.toString());
        for (ChannelTicketInfo info : infos) {
            String s = spannable.toString();
            StringBuilder sb = new StringBuilder(s);
            String enterStr = "\u70b9\u51fb\u8fdb\u5165" + info.sid + "\u9891\u9053";
            sb.replace(info.start, info.end, "{air}" + enterStr);
            SpannableStringBuilder spannable1 = new SpannableStringBuilder((CharSequence)sb);
            spannable1.setSpan((Object)new CustomImageSpan(this.ticketDrawable, 2, ResolutionUtils.convertDpToPixel(6.0f, context), ResolutionUtils.convertDpToPixel(6.0f, context)), info.start, info.start + "{air}".length(), 33);
            UnderlineSpan span = new UnderlineSpan();
            spannable1.setSpan((Object)span, info.start, info.start + "{air}".length() + enterStr.length(), 33);
            final ChannelTicketInfo inf = info;
            MyClickableSpan airClickableSpan = new MyClickableSpan(new View.OnClickListener(){

                public void onClick(View view) {
                    if (NewChannelAirTicketFilter.this.airClickListener != null) {
                        NewChannelAirTicketFilter.this.airClickListener.onSpanClick(inf.sid, inf.subSid);
                    }
                }
            });
            spannable1.setSpan((Object)airClickableSpan, info.start, info.start + "{air}".length() + enterStr.length(), 33);
            spannable = spannable1;
        }
        return spannable;
    }

    public static boolean isChannelTicketMessage(CharSequence msg) {
        return ChannelAirTicketParser.isChannelTicketMessage(msg);
    }

    public static String replaceChannelTicketWithGivenStr(String message, String givenStr) {
        CharSequence complateFormatMsg = ChannelAirTicketParser.parseCompleteFormatMsg(message);
        Matcher m = ChannelAirTicketParser.AIR_TICKET_PATTERN.matcher(complateFormatMsg);
        return m.replaceAll(givenStr).trim();
    }

    public static interface AirSpanClickListener {
        public void onSpanClick(long var1, long var3);
    }

    class MyClickableSpan
    extends ClickableSpan {
        private View.OnClickListener mListener;

        public MyClickableSpan(View.OnClickListener l) {
            this.mListener = l;
        }

        public void updateDrawState(TextPaint ds) {
            super.updateDrawState(ds);
            ds.setColor(Color.parseColor((String)"#ffda81"));
        }

        public void onClick(View v) {
            this.mListener.onClick(v);
        }
    }

    public static class ChannelTicketInfo {
        public int start;
        public int end;
        public long sid;
        public long subSid;

        public ChannelTicketInfo(int start, int end, long sid, long subSid) {
            this.start = start;
            this.end = end;
            this.sid = sid;
            this.subSid = subSid;
        }

        public String toString() {
            return "[start = " + this.start + "; end = " + this.end + "; sid = " + this.sid + "; subSid = " + this.subSid + "]";
        }
    }
}

