/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.imageloader;

import android.app.Activity;
import android.app.Application;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.framework.R;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.IRecycler;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.ImageUtil;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.util.ArrayList;

public class BigPicRecycler {
    private static volatile boolean sBigImageAutoRecycle = true;
    private static volatile int sBigRecycleSizeMultiplier = 5;
    private static IRecycler sRecycler;
    private static final ArrayList<YYTaskExecutor.RunnableEx> sRunnables;

    public static void init(Application application, IRecycler recycler) {
        if (Build.VERSION.SDK_INT < 24) {
            sRecycler = recycler;
            YYActivityManager.INSTANCE.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    for (YYTaskExecutor.RunnableEx runnableEx : sRunnables) {
                        if (runnableEx.getArg() != activity) continue;
                        YYTaskExecutor.removeRunnableFromMainThread(runnableEx);
                        sRunnables.remove(runnableEx);
                        break;
                    }
                    BigPicRecycler.recoveryBigPicIfNeed(activity);
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityStopped(Activity activity) {
                    YYTaskExecutor.RunnableEx runnableEx = new YYTaskExecutor.RunnableEx(){

                        @Override
                        public void run() {
                            if (this.getArg() instanceof Activity) {
                                BigPicRecycler.recycleBigPicIfNeed((Activity)this.getArg());
                            }
                            sRunnables.remove(this);
                        }
                    };
                    runnableEx.setArg(activity);
                    sRunnables.add(runnableEx);
                    YYTaskExecutor.postToMainThread(runnableEx, 5000L);
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                    for (YYTaskExecutor.RunnableEx runnableEx : sRunnables) {
                        if (runnableEx.getArg() != activity) continue;
                        YYTaskExecutor.removeRunnableFromMainThread(runnableEx);
                        sRunnables.remove(runnableEx);
                        break;
                    }
                }
            });
        }
    }

    public static void updateParams(boolean bigImageAutoRecycle, int recycleSizeMultiplier) {
        sBigImageAutoRecycle = bigImageAutoRecycle;
        sBigRecycleSizeMultiplier = recycleSizeMultiplier;
    }

    private static void recycleBigPicIfNeed(Activity activity) {
        View rootView;
        if (!sBigImageAutoRecycle || activity == null) {
            return;
        }
        if (BasicConfig.getInstance().isDebuggable() && ImageLoader.sDebugSwitch && MLog.isLogLevelAboveDebug()) {
            MLog.debug("BigPicRecycler", "recycleBigPic activity:" + activity.toString(), new Object[0]);
        }
        if ((rootView = activity.getWindow().getDecorView()) instanceof ViewGroup) {
            BigPicRecycler.recycleBigPicIfNeed((ViewGroup)rootView);
            rootView.setTag(R.id.yy_bigpic_recycled, (Object)true);
        }
    }

    private static void recoveryBigPicIfNeed(Activity activity) {
        if (activity == null) {
            return;
        }
        View rootView = activity.getWindow().getDecorView();
        if (rootView instanceof ViewGroup) {
            boolean needRecovery;
            boolean bl = needRecovery = rootView.getTag(R.id.yy_bigpic_recycled) instanceof Boolean ? (Boolean)rootView.getTag(R.id.yy_bigpic_recycled) : false;
            if (needRecovery || sBigImageAutoRecycle) {
                if (BasicConfig.getInstance().isDebuggable() && ImageLoader.sDebugSwitch && MLog.isLogLevelAboveDebug()) {
                    MLog.debug("BigPicRecycler", "recovery:" + activity.toString(), new Object[0]);
                }
                BigPicRecycler.recoveryBigPicIfNeed((ViewGroup)rootView);
                rootView.setTag(R.id.yy_bigpic_recycled, (Object)false);
            }
        }
    }

    private static void recycleBigPicIfNeed(ViewGroup viewGroup) {
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null) continue;
            if (child instanceof ViewGroup) {
                BigPicRecycler.recycleBigPicIfNeed((ViewGroup)child);
                continue;
            }
            if (!(child instanceof ImageView)) continue;
            BigPicRecycler.recycleBigPicIfNeed((ImageView)child);
        }
    }

    private static void recycleBigPicIfNeed(ImageView child) {
        if (child == null || !(child instanceof RecycleImageView)) {
            return;
        }
        RecycleImageView imageView = (RecycleImageView)child;
        Drawable drawable2 = imageView.getImageDrawableInner();
        if (drawable2 != null && !(drawable2 instanceof GifDrawable)) {
            Bitmap bitmap = ImageLoader.getBitmapFromCustomDrawable(drawable2);
            float size = ImageConfig.fullImageConfig().getImagePrecision().getHeight() * ImageConfig.fullImageConfig().getImagePrecision().getWidth();
            size = size < 777600.0f ? 77760.0f : (size *= 0.1f);
            if ((float)ImageUtil.getBitmapSize(bitmap) >= size * (float)sBigRecycleSizeMultiplier && sRecycler != null && sRecycler.recycle(imageView)) {
                imageView.setTag(R.id.yy_bigpic_recycled, true);
                MLog.info("BigPicRecycler", "recycle imageView:" + imageView.toString(), new Object[0]);
            }
        }
    }

    private static void recoveryBigPicIfNeed(ViewGroup viewGroup) {
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null) continue;
            if (child instanceof ViewGroup) {
                BigPicRecycler.recoveryBigPicIfNeed((ViewGroup)child);
                continue;
            }
            if (!(child instanceof ImageView)) continue;
            BigPicRecycler.recoveryBigPicIfNeed((ImageView)child);
        }
    }

    private static void recoveryBigPicIfNeed(ImageView child) {
        if (child == null || !(child instanceof RecycleImageView)) {
            return;
        }
        RecycleImageView imageView = (RecycleImageView)child;
        Drawable drawable2 = imageView.getImageDrawableInner();
        if (drawable2 == null) {
            boolean needRecovery;
            Object tag = imageView.getTag(R.id.yy_bigpic_recycled);
            boolean bl = needRecovery = tag instanceof Boolean ? (Boolean)tag : false;
            if (needRecovery && sRecycler != null) {
                sRecycler.recovery(imageView);
                child.setTag(R.id.yy_bigpic_recycled, (Object)false);
                MLog.info("BigPicRecycler", "recovery imageView:" + imageView.toString(), new Object[0]);
            }
        }
    }

    static {
        sRunnables = new ArrayList(12);
    }
}

