/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;

public class HttpLog {
    private static final String TAG = "HttpLog";
    private static boolean verboseLogEnable = false;

    public static boolean isDebug() {
        return BasicConfig.getInstance().isDebuggable();
    }

    public static void v(String format, Object ... args) {
        if (verboseLogEnable) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, format, args);
            }
        } else if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose(TAG, format, args);
        }
    }

    public static void i(String format, Object ... args) {
        MLog.info(TAG, format, args);
    }

    public static void d(String format, Object ... args) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, format, args);
        }
    }

    public static void e(String format, Object ... args) {
        MLog.error((Object)TAG, format, args);
    }

    public static void e(Throwable tr, String format, Object ... args) {
        MLog.error((Object)TAG, format, tr, args);
    }

    static String format(String format, Object ... args) {
        try {
            return String.format(format, args);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void setVerboseLogEnable(boolean enable) {
        verboseLogEnable = enable;
    }
}

