/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.image;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import com.yy.mobile.http.HttpLog;

public class RecycleBitmapDrawable
extends BitmapDrawable {
    static final String LOG_TAG = "CountingBitmapDrawable";
    private int mCacheRefCount = 0;
    private int mDisplayRefCount = 0;
    private boolean mHasBeenDisplayed;

    public RecycleBitmapDrawable(Resources res, Bitmap bitmap) {
        super(res, bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsDisplayed(boolean isDisplayed) {
        RecycleBitmapDrawable recycleBitmapDrawable = this;
        synchronized (recycleBitmapDrawable) {
            if (isDisplayed) {
                ++this.mDisplayRefCount;
                this.mHasBeenDisplayed = true;
            } else {
                --this.mDisplayRefCount;
            }
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsCached(boolean isCached) {
        RecycleBitmapDrawable recycleBitmapDrawable = this;
        synchronized (recycleBitmapDrawable) {
            this.mCacheRefCount = isCached ? ++this.mCacheRefCount : --this.mCacheRefCount;
            this.checkState();
        }
    }

    private synchronized void checkState() {
        if (this.mCacheRefCount <= 0 && this.mDisplayRefCount <= 0 && this.mHasBeenDisplayed && this.hasValidBitmap()) {
            HttpLog.v("No longer being used or cached so recycling. ", new Object[0]);
            this.getBitmap().recycle();
        }
    }

    private synchronized boolean hasValidBitmap() {
        Bitmap bitmap = this.getBitmap();
        return bitmap != null && !bitmap.isRecycled();
    }
}

