/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.wheelview;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public class WheelView
extends ScrollView {
    public static final String TAG = "WheelView";
    private OnWheelViewListener onWheelViewListener;
    private static final int SCROLL_DIRECTION_UP = 0;
    private static final int SCROLL_DIRECTION_DOWN = 1;
    public static final int OFF_SET_DEFAULT = 1;
    private int offset = 1;
    private int initialY;
    private Runnable scrollerTask;
    private int newCheck = 50;
    private int displayItemCount;
    private int selectedIndex = 1;
    private int[] selectedAreaBorder;
    private int scrollDirection = -1;
    private List<String> mListData;
    private Paint paint;
    private int viewWidth;
    private int itemHeight = 0;
    private Context context;
    private LinearLayout mListView;

    public OnWheelViewListener getOnWheelViewListener() {
        return this.onWheelViewListener;
    }

    public void setOnWheelViewListener(OnWheelViewListener onWheelViewListener) {
        this.onWheelViewListener = onWheelViewListener;
    }

    public WheelView(Context context) {
        super(context);
        this.init(context);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public WheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private List<String> getItems() {
        return this.mListData;
    }

    public void setItems(List<String> list) {
        if (null == this.mListData) {
            this.mListData = new ArrayList<String>();
        }
        this.destroyView();
        this.mListData.addAll(list);
        for (int i = 0; i < this.offset; ++i) {
            this.mListData.add(0, "");
            this.mListData.add("");
        }
        this.initData();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    private void init(Context context) {
        this.context = context;
        this.setVerticalScrollBarEnabled(false);
        this.mListView = new LinearLayout(context);
        this.mListView.setOrientation(1);
        this.addView((View)this.mListView);
        this.scrollerTask = new Runnable(){

            @Override
            public void run() {
                int newY = WheelView.this.getScrollY();
                if (WheelView.this.initialY - newY == 0) {
                    final int remainder = WheelView.this.initialY % WheelView.this.itemHeight;
                    final int divided = WheelView.this.initialY / WheelView.this.itemHeight;
                    if (remainder == 0) {
                        WheelView.this.selectedIndex = divided + WheelView.this.offset;
                        WheelView.this.onSeletedCallBack();
                    } else if (remainder > WheelView.this.itemHeight / 2) {
                        WheelView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                WheelView.this.smoothScrollTo(0, WheelView.this.initialY - remainder + WheelView.this.itemHeight);
                                WheelView.this.selectedIndex = divided + WheelView.this.offset + 1;
                                WheelView.this.onSeletedCallBack();
                            }
                        });
                    } else {
                        WheelView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                WheelView.this.smoothScrollTo(0, WheelView.this.initialY - remainder);
                                WheelView.this.selectedIndex = divided + WheelView.this.offset;
                                WheelView.this.onSeletedCallBack();
                            }
                        });
                    }
                } else {
                    WheelView.this.initialY = WheelView.this.getScrollY();
                    WheelView.this.postDelayed(WheelView.this.scrollerTask, WheelView.this.newCheck);
                }
            }
        };
    }

    public void startScrollerTask() {
        this.initialY = this.getScrollY();
        this.postDelayed(this.scrollerTask, this.newCheck);
    }

    private void initData() {
        this.displayItemCount = this.offset * 2 + 1;
        for (String item : this.mListData) {
            this.mListView.addView((View)this.createView(item));
        }
        this.refreshItemView(0);
    }

    private TextView createView(String item) {
        TextView tv = new TextView(this.context);
        tv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        tv.setSingleLine(true);
        tv.setTextSize(2, 16.0f);
        tv.setText((CharSequence)item);
        tv.setGravity(17);
        int padding = this.dip2px(5.0f);
        tv.setPadding(padding, padding, padding, padding);
        if (this.itemHeight == 0) {
            this.itemHeight = this.getViewMeasuredHeight((View)tv);
            this.mListView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.itemHeight * this.displayItemCount));
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getLayoutParams();
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(lp.width, this.itemHeight * this.displayItemCount));
        }
        return tv;
    }

    private void destroyView() {
        if (this.mListData != null) {
            this.mListData.clear();
        }
        if (this.mListView != null) {
            this.mListView.removeAllViews();
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.scrollDirection = t > oldt ? 1 : 0;
        this.refreshItemView(t);
    }

    private void refreshItemView(int y) {
        int position = y / this.itemHeight + this.offset;
        int remainder = y % this.itemHeight;
        int divided = y / this.itemHeight;
        if (remainder == 0) {
            position = divided + this.offset;
        } else if (remainder > this.itemHeight / 2) {
            position = divided + this.offset + 1;
        }
        int childSize = this.mListView.getChildCount();
        for (int i = 0; i < childSize; ++i) {
            TextView itemView = (TextView)this.mListView.getChildAt(i);
            if (null == itemView) {
                return;
            }
            if (position == i) {
                itemView.setTextColor(Color.parseColor((String)"#333333"));
                continue;
            }
            itemView.setTextColor(Color.parseColor((String)"#bbbbbb"));
        }
    }

    private int[] obtainSelectedAreaBorder() {
        if (this.selectedAreaBorder == null) {
            this.selectedAreaBorder = new int[2];
            this.selectedAreaBorder[0] = this.itemHeight * this.offset;
            this.selectedAreaBorder[1] = this.itemHeight * (this.offset + 1);
        }
        return this.selectedAreaBorder;
    }

    public void setBackgroundDrawable(Drawable background) {
        if (this.viewWidth == 0) {
            this.viewWidth = ((Activity)this.context).getWindowManager().getDefaultDisplay().getWidth();
        }
        if (null == this.paint) {
            this.paint = new Paint();
            this.paint.setColor(Color.parseColor((String)"#999999"));
            this.paint.setStrokeWidth((float)this.dip2px(1.0f));
        }
        background = new Drawable(){

            public void draw(Canvas canvas) {
                canvas.drawLine(0.0f, (float)WheelView.this.obtainSelectedAreaBorder()[0], (float)WheelView.this.viewWidth, (float)WheelView.this.obtainSelectedAreaBorder()[0], WheelView.this.paint);
                canvas.drawLine(0.0f, (float)WheelView.this.obtainSelectedAreaBorder()[1], (float)WheelView.this.viewWidth, (float)WheelView.this.obtainSelectedAreaBorder()[1], WheelView.this.paint);
            }

            public void setAlpha(int alpha) {
            }

            public void setColorFilter(ColorFilter cf) {
            }

            public int getOpacity() {
                return 0;
            }
        };
        super.setBackgroundDrawable(background);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.viewWidth = w;
        this.setBackgroundDrawable(null);
    }

    private void onSeletedCallBack() {
        if (this.onWheelViewListener != null) {
            this.onWheelViewListener.onSelected(this.selectedIndex, this.mListData.get(this.selectedIndex));
        }
    }

    public void setSeletion(int position) {
        final int p = position;
        this.selectedIndex = p + this.offset;
        this.post(new Runnable(){

            @Override
            public void run() {
                WheelView.this.smoothScrollTo(0, p * WheelView.this.itemHeight);
            }
        });
    }

    public void setSeletion(String seletion) {
        if (seletion != null && !seletion.isEmpty() && this.mListData != null && this.mListData.size() > 0) {
            for (int position = 0; position < this.mListData.size(); ++position) {
                if (!this.mListData.get(position).equals(seletion)) continue;
                this.setSeletion(position - this.offset);
            }
        }
    }

    public String getSeletedItem() {
        return this.mListData.get(this.selectedIndex);
    }

    public int getSeletedIndex() {
        return this.selectedIndex - this.offset;
    }

    public void fling(int velocityY) {
        super.fling(velocityY / 3);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1) {
            this.startScrollerTask();
        }
        return super.onTouchEvent(ev);
    }

    private int dip2px(float dpValue) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private int getViewMeasuredHeight(View view) {
        int width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int expandSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        view.measure(width, expandSpec);
        return view.getMeasuredHeight();
    }

    public static interface OnWheelViewListener {
        public void onSelected(int var1, String var2);
    }
}

