/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.EditText;

public class EditTextWithClear
extends EditText {
    private Drawable dRight;
    private Rect rBounds;

    public EditTextWithClear(Context paramContext) {
        super(paramContext);
        this.initEditText();
    }

    public EditTextWithClear(Context paramContext, AttributeSet paramAttributeSet) {
        super(paramContext, paramAttributeSet);
        this.initEditText();
    }

    public EditTextWithClear(Context paramContext, AttributeSet paramAttributeSet, int paramInt) {
        super(paramContext, paramAttributeSet, paramInt);
        this.initEditText();
    }

    private void initEditText() {
        this.setEditTextDrawable();
        this.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable paramEditable) {
            }

            public void beforeTextChanged(CharSequence paramCharSequence, int paramInt1, int paramInt2, int paramInt3) {
            }

            public void onTextChanged(CharSequence paramCharSequence, int paramInt1, int paramInt2, int paramInt3) {
                EditTextWithClear.this.setEditTextDrawable();
            }
        });
    }

    public void setEditTextDrawable() {
        if (this.getText().toString().length() == 0) {
            this.setCompoundDrawables(null, null, null, null);
        } else {
            this.setCompoundDrawables(null, null, this.dRight, null);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dRight = null;
        this.rBounds = null;
    }

    public boolean onTouchEvent(MotionEvent paramMotionEvent) {
        if (this.dRight != null && paramMotionEvent.getAction() == 1) {
            this.rBounds = this.dRight.getBounds();
            int i = (int)paramMotionEvent.getRawX();
            if (i > this.getRight() - 3 * this.rBounds.width()) {
                this.setText("");
                paramMotionEvent.setAction(3);
            }
        }
        return super.onTouchEvent(paramMotionEvent);
    }

    public void setCompoundDrawables(Drawable paramDrawable1, Drawable paramDrawable2, Drawable paramDrawable3, Drawable paramDrawable4) {
        if (paramDrawable3 != null) {
            this.dRight = paramDrawable3;
        }
        super.setCompoundDrawables(paramDrawable1, paramDrawable2, paramDrawable3, paramDrawable4);
    }
}

