/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.yy.mobile.framework.R;
import com.yy.mobile.util.log.MLog;

public class CustomHeightViewPager
extends ViewPager {
    private static final String TAG = "CustomHeightViewPager";
    private boolean isCanScroll = true;
    private int topHeight;
    private int height;

    public CustomHeightViewPager(Context context) {
        super(context);
        this.init();
    }

    public CustomHeightViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.topHeight = this.getContext().getResources().getDimensionPixelSize(R.dimen.navigation_bar1_height) + this.getContext().getResources().getDimensionPixelSize(R.dimen.person_page_tab_strip1_height) + this.getContext().getResources().getDimensionPixelSize(R.dimen.person_page_bottom1_height);
    }

    public void showOrHideBottom(boolean showBottom) {
        this.topHeight = showBottom ? this.getContext().getResources().getDimensionPixelSize(R.dimen.navigation_bar1_height) + this.getContext().getResources().getDimensionPixelSize(R.dimen.person_page_tab_strip1_height) + this.getContext().getResources().getDimensionPixelSize(R.dimen.person_page_bottom1_height) : this.getContext().getResources().getDimensionPixelSize(R.dimen.navigation_bar1_height) + this.getContext().getResources().getDimensionPixelSize(R.dimen.person_page_tab_strip1_height);
        this.height = 0;
        this.requestLayout();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "dispatchTouchEvent action = " + ev.getAction(), new Object[0]);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "onTouchEvent action = " + ev.getAction(), new Object[0]);
        }
        try {
            if (!this.isCanScroll) {
                return false;
            }
            return super.onTouchEvent(ev);
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, "xuwakao, onTouchEvent fix touch viewpager error happens, ev = " + ev, new Object[0]);
            return false;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "onInterceptTouchEvent action = " + ev.getAction(), new Object[0]);
        }
        try {
            if (!this.isCanScroll) {
                return false;
            }
            return super.onInterceptTouchEvent(ev);
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "xuwakao, onInterceptTouchEvent fix touch viewpager error happens, ev= " + ev, new Object[0]);
            return false;
        }
    }

    public void setCanScroll(boolean isCanScroll) {
        this.isCanScroll = isCanScroll;
    }

    public void scrollTo(int x, int y) {
        if (this.isCanScroll) {
            super.scrollTo(x, y);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.height <= 0) {
            this.height = this.getRootView().findViewById(0x1020002).getHeight() - this.topHeight;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "CustomListView-- height = " + this.height, new Object[0]);
            }
        }
        if (this.height != 0) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.height, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

