/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext.media;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ReplacementSpan;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.WeakReference;

public abstract class SafeDynamicDrawableSpan
extends ReplacementSpan {
    private static final String TAG = "SafeDynamicDrawableSpan";
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    protected final int mVerticalAlignment;
    private WeakReference<Drawable> mDrawableRef;

    public SafeDynamicDrawableSpan() {
        this.mVerticalAlignment = 0;
    }

    protected SafeDynamicDrawableSpan(int verticalAlignment) {
        this.mVerticalAlignment = verticalAlignment;
    }

    public int getVerticalAlignment() {
        return this.mVerticalAlignment;
    }

    public abstract Drawable getDrawable();

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        Drawable d = this.getCachedDrawable();
        MLog.info(TAG, "getSize d's value is " + d, new Object[0]);
        Rect rect = d.getBounds();
        if (fm != null) {
            fm.ascent = -rect.bottom;
            fm.descent = 0;
            fm.top = fm.ascent;
            fm.bottom = 0;
        }
        return rect.right;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Drawable b = this.getCachedDrawable();
        canvas.save();
        int transY = bottom - b.getBounds().bottom;
        if (this.mVerticalAlignment == 1) {
            transY -= paint.getFontMetricsInt().descent;
        }
        canvas.translate(x, (float)transY);
        b.draw(canvas);
        canvas.restore();
    }

    private Drawable getCachedDrawable() {
        WeakReference<Drawable> wr = this.mDrawableRef;
        Drawable d = null;
        if (wr != null) {
            d = (Drawable)wr.get();
        }
        if (d == null) {
            d = this.getDrawable();
            MLog.info(TAG, "getCachedDrawable d's value is " + d, new Object[0]);
            this.mDrawableRef = new WeakReference<Drawable>(d);
        }
        return d;
    }
}

