/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import com.yy.mobile.util.log.MLog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChannelAirTicketParser {
    public static final String AIR_TICKET_REG_STYLE1 = "(((?i)yy)://(\\d+))";
    public static final Pattern AIR_TICKET_PATTERN_STYLE1 = Pattern.compile("(((?i)yy)://(\\d+))", 2);
    public static final String AIR_TICKET_REG = "((((?i)yy)://pd-)((\\[([^\\].]+)\\])|(\\w+))(/\\[([^\\]]+)\\])?)";
    public static final Pattern AIR_TICKET_PATTERN = Pattern.compile("((((?i)yy)://pd-)((\\[([^\\].]+)\\])|(\\w+))(/\\[([^\\]]+)\\])?)", 2);

    public static boolean isChannelTicketMessage(CharSequence msg) {
        CharSequence transformMsg = ChannelAirTicketParser.parseCompleteFormatMsg(msg);
        if (transformMsg == null) {
            return false;
        }
        boolean findReg = AIR_TICKET_PATTERN.matcher(transformMsg).find();
        return findReg;
    }

    public static CharSequence parseCompleteFormatMsg(CharSequence msg) {
        CharSequence transformMsg = msg;
        Matcher style1Matcher = AIR_TICKET_PATTERN_STYLE1.matcher(msg);
        while (style1Matcher.find()) {
            try {
                int start = style1Matcher.start();
                int end = style1Matcher.end();
                CharSequence matchedStr = transformMsg.subSequence(start, end);
                CharSequence headStr = matchedStr.subSequence(0, 2);
                String headedStr = matchedStr.toString().replace(headStr, "yy");
                String convertedStr = headedStr.toString().replace("yy://", "yy://pd-");
                transformMsg = AIR_TICKET_PATTERN_STYLE1.matcher(msg).replaceFirst(convertedStr);
            }
            catch (Throwable throwable) {
                MLog.error((Object)"[ChannelAirTicketParser]", "[parseCompleteFormatMsg] error! " + throwable, new Object[0]);
            }
        }
        return transformMsg;
    }
}

